/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerOperationResponseClassReader
implements OperationBuilderPlugin {
    private static Logger log = LoggerFactory.getLogger(SwaggerOperationResponseClassReader.class);
    private final TypeResolver typeResolver;
    private final TypeNameExtractor nameExtractor;

    @Autowired
    public SwaggerOperationResponseClassReader(TypeResolver typeResolver, TypeNameExtractor nameExtractor) {
        this.typeResolver = typeResolver;
        this.nameExtractor = nameExtractor;
    }

    @Override
    public void apply(OperationContext context) {
        ResolvedType returnType = context.alternateFor(context.getReturnType());
        returnType = context.findAnnotation(ApiOperation.class).transform(Annotations.resolvedTypeFromOperation(this.typeResolver, returnType)).or(returnType);
        if (this.canSkip(context, returnType)) {
            return;
        }
        ModelContext modelContext = ModelContext.returnValue(context.getGroupName(), returnType, context.getDocumentationType(), context.getAlternateTypeProvider(), context.getGenericsNamingStrategy(), context.getIgnorableParameterTypes());
        String responseTypeName = this.nameExtractor.typeName(modelContext);
        log.debug("Setting response class to:" + responseTypeName);
        context.operationBuilder().responseModel(ResolvedTypes.modelRefFactory(modelContext, this.nameExtractor).apply(returnType));
    }

    private boolean canSkip(OperationContext context, ResolvedType returnType) {
        return context.getIgnorableParameterTypes().contains(returnType.getErasedType());
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

