/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerOperationModelsProvider
implements OperationModelsProviderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerOperationModelsProvider.class);
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerOperationModelsProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Override
    public void apply(RequestMappingContext context) {
        this.collectFromApiOperation(context);
        this.collectApiResponses(context);
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private void collectFromApiOperation(RequestMappingContext context) {
        ResolvedType returnType = context.getReturnType();
        returnType = context.alternateFor(returnType);
        Optional<ResolvedType> returnParameter = context.findAnnotation(ApiOperation.class).transform(Annotations.resolvedTypeFromOperation(this.typeResolver, returnType));
        if (returnParameter.isPresent() && returnParameter.get() != returnType) {
            LOG.debug("Adding return parameter of type {}", (Object)ResolvedTypes.resolvedTypeSignature(returnParameter.get()).or("<null>"));
            context.operationModelsBuilder().addReturn(returnParameter.get());
        }
    }

    private void collectApiResponses(RequestMappingContext context) {
        List<ApiResponses> allApiResponses = context.findAnnotations(ApiResponses.class);
        LOG.debug("Reading parameters models for handlerMethod |{}|", (Object)context.getName());
        HashSet<ResolvedType> seenTypes = Sets.newHashSet();
        for (ApiResponses apiResponses : allApiResponses) {
            List<ResolvedType> modelTypes = this.toResolvedTypes(context).apply(apiResponses);
            for (ResolvedType modelType : modelTypes) {
                if (seenTypes.contains(modelType)) continue;
                seenTypes.add(modelType);
                context.operationModelsBuilder().addReturn(modelType);
            }
        }
    }

    private Function<ApiResponses, List<ResolvedType>> toResolvedTypes(final RequestMappingContext context) {
        return new Function<ApiResponses, List<ResolvedType>>(){

            @Override
            public List<ResolvedType> apply(ApiResponses input) {
                ArrayList<ResolvedType> resolvedTypes = Lists.newArrayList();
                for (ApiResponse response : input.value()) {
                    ResolvedType modelType = context.alternateFor(SwaggerOperationModelsProvider.this.typeResolver.resolve(response.response(), new Type[0]));
                    LOG.debug("Adding input parameter of type {}", (Object)ResolvedTypes.resolvedTypeSignature(modelType).or("<null>"));
                    resolvedTypes.add(modelType);
                }
                return resolvedTypes;
            }
        };
    }
}

