/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerMediaTypeReader
implements OperationBuilderPlugin {
    @Override
    public void apply(OperationContext context) {
        Optional<ApiOperation> annotation = context.findAnnotation(ApiOperation.class);
        if (annotation.isPresent()) {
            context.operationBuilder().consumes(this.asSet(Strings.nullToEmpty(annotation.get().consumes())));
            context.operationBuilder().produces(this.asSet(Strings.nullToEmpty(annotation.get().produces())));
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private Set<String> asSet(String mediaTypes) {
        return Sets.newHashSet(Splitter.on(',').trimResults().omitEmptyStrings().splitToList(mediaTypes));
    }
}

