/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.common;

import javax.servlet.http.HttpServletRequest;
import org.springframework.core.SpringVersion;
import springfox.documentation.service.PathAdjuster;
import springfox.documentation.swagger.common.SpringVersionCapability;

public class XForwardPrefixPathAdjuster
implements PathAdjuster {
    static final String X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    private final HttpServletRequest request;

    public XForwardPrefixPathAdjuster(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String adjustedPath(String path) {
        String prefix = this.request.getHeader(X_FORWARDED_PREFIX);
        if (prefix != null) {
            if (!SpringVersionCapability.supportsXForwardPrefixHeader(SpringVersion.getVersion())) {
                return prefix + path;
            }
            return prefix;
        }
        return path;
    }
}

