/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class MediaTypeReader
implements OperationBuilderPlugin,
ApiListingBuilderPlugin {
    @Override
    public void apply(OperationContext context) {
        DocumentationContext documentationContext = context.getDocumentationContext();
        Set<String> operationConsumesList = this.toSet(context.consumes());
        Set<String> operationProducesList = this.toSet(context.produces());
        if (this.handlerMethodHasFileParameter(context)) {
            operationConsumesList = Sets.newHashSet("multipart/form-data");
        }
        if (operationProducesList.isEmpty() && documentationContext.getProduces().isEmpty()) {
            operationProducesList.add("*/*");
        }
        if (operationConsumesList.isEmpty() && documentationContext.getConsumes().isEmpty()) {
            operationConsumesList.add("application/json");
        }
        context.operationBuilder().consumes(operationConsumesList);
        context.operationBuilder().produces(operationProducesList);
    }

    @Override
    public void apply(ApiListingContext context) {
        RequestMapping annotation;
        Optional<Class<?>> controller = context.getResourceGroup().getControllerClass();
        if (controller.isPresent() && (annotation = AnnotationUtils.findAnnotation(controller.get(), RequestMapping.class)) != null) {
            context.apiListingBuilder().appendProduces(Lists.newArrayList(annotation.produces())).appendConsumes(Lists.newArrayList(annotation.consumes()));
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private boolean handlerMethodHasFileParameter(OperationContext context) {
        List<ResolvedMethodParameter> methodParameters = context.getParameters();
        for (ResolvedMethodParameter resolvedMethodParameter : methodParameters) {
            if (!MultipartFile.class.isAssignableFrom(resolvedMethodParameter.getParameterType().getErasedType())) continue;
            return true;
        }
        return false;
    }

    private Set<String> toSet(Set<? extends MediaType> mediaTypeSet) {
        HashSet<String> mediaTypes = Sets.newHashSet();
        for (MediaType mediaType : mediaTypeSet) {
            mediaTypes.add(mediaType.toString());
        }
        return mediaTypes;
    }
}

