/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.Model;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.paths.PathMappingAdjuster;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDescriptionReader;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;
import springfox.documentation.spring.web.scanners.ApiModelReader;
import springfox.documentation.spring.web.scanners.ResourceGroups;
import springfox.documentation.spring.web.scanners.ResourcePathProvider;

@Component
public class ApiListingScanner {
    private final ApiDescriptionReader apiDescriptionReader;
    private final ApiModelReader apiModelReader;
    private final DocumentationPluginsManager pluginsManager;

    @Autowired
    public ApiListingScanner(ApiDescriptionReader apiDescriptionReader, ApiModelReader apiModelReader, DocumentationPluginsManager pluginsManager) {
        this.apiDescriptionReader = apiDescriptionReader;
        this.apiModelReader = apiModelReader;
        this.pluginsManager = pluginsManager;
    }

    static Optional<String> longestCommonPath(List<ApiDescription> apiDescriptions) {
        ArrayList<String> commons = Lists.newArrayList();
        if (null == apiDescriptions || apiDescriptions.isEmpty()) {
            return Optional.absent();
        }
        List<String> firstWords = ApiListingScanner.urlParts(apiDescriptions.get(0));
        for (int position = 0; position < firstWords.size(); ++position) {
            String word = firstWords.get(position);
            boolean allContain = true;
            for (int i2 = 1; i2 < apiDescriptions.size(); ++i2) {
                List<String> words = ApiListingScanner.urlParts(apiDescriptions.get(i2));
                if (words.size() >= position + 1 && words.get(position).equals(word)) continue;
                allContain = false;
                break;
            }
            if (!allContain) continue;
            commons.add(word);
        }
        Joiner joiner = Joiner.on("/").skipNulls();
        return Optional.of("/" + joiner.join(commons));
    }

    static List<String> urlParts(ApiDescription apiDescription) {
        return Splitter.on('/').omitEmptyStrings().trimResults().splitToList(apiDescription.getPath());
    }

    public Multimap<String, ApiListing> scan(ApiListingScanningContext context) {
        LinkedListMultimap<String, ApiListing> apiListingMap = LinkedListMultimap.create();
        int position = 0;
        Map<ResourceGroup, List<RequestMappingContext>> requestMappingsByResourceGroup = context.getRequestMappingsByResourceGroup();
        Collection<ApiDescription> additionalListings = this.pluginsManager.additionalListings(context);
        ImmutableSet<ResourceGroup> allResourceGroups = FluentIterable.from(ResourceGroups.collectResourceGroups(additionalListings)).append((Iterable<ResourceGroup>)requestMappingsByResourceGroup.keySet()).toSet();
        ArrayList<SecurityReference> securityReferences = Lists.newArrayList();
        for (ResourceGroup resourceGroup : ResourceGroups.sortedByName(allResourceGroups)) {
            DocumentationContext documentationContext = context.getDocumentationContext();
            LinkedHashSet<String> produces = new LinkedHashSet<String>(documentationContext.getProduces());
            LinkedHashSet<String> consumes = new LinkedHashSet<String>(documentationContext.getConsumes());
            String host = documentationContext.getHost();
            LinkedHashSet<String> protocols = new LinkedHashSet<String>(documentationContext.getProtocols());
            HashSet<ApiDescription> apiDescriptions = Sets.newHashSet();
            LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
            List<RequestMappingContext> requestMappings = BuilderDefaults.nullToEmptyList((Collection)requestMappingsByResourceGroup.get(resourceGroup));
            for (RequestMappingContext each : this.sortedByMethods(requestMappings)) {
                models.putAll(this.apiModelReader.read(each.withKnownModels(models)));
                apiDescriptions.addAll(this.apiDescriptionReader.read(each));
            }
            ImmutableList<ApiDescription> additional = FluentIterable.from(additionalListings).filter(Predicates.and(ResourceGroups.belongsTo(resourceGroup.getGroupName()), this.onlySelectedApis(documentationContext))).toList();
            apiDescriptions.addAll(additional);
            ImmutableList<ApiDescription> sortedApis = FluentIterable.from(apiDescriptions).toSortedList(documentationContext.getApiDescriptionOrdering());
            String resourcePath = new ResourcePathProvider(resourceGroup).resourcePath().or(ApiListingScanner.longestCommonPath(sortedApis)).orNull();
            PathProvider pathProvider = documentationContext.getPathProvider();
            String basePath = pathProvider.getApplicationBasePath();
            PathMappingAdjuster adjuster = new PathMappingAdjuster(documentationContext);
            ApiListingBuilder apiListingBuilder = new ApiListingBuilder(context.apiDescriptionOrdering()).apiVersion(documentationContext.getApiInfo().getVersion()).basePath(adjuster.adjustedPath(basePath)).resourcePath(resourcePath).produces(produces).consumes(consumes).host(host).protocols(protocols).securityReferences(securityReferences).apis(sortedApis).models(models).position(position++).availableTags(documentationContext.getTags());
            ApiListingContext apiListingContext = new ApiListingContext(context.getDocumentationType(), resourceGroup, apiListingBuilder);
            apiListingMap.put(resourceGroup.getGroupName(), this.pluginsManager.apiListing(apiListingContext));
        }
        return apiListingMap;
    }

    private Predicate<ApiDescription> onlySelectedApis(final DocumentationContext context) {
        return new Predicate<ApiDescription>(){

            @Override
            public boolean apply(ApiDescription input) {
                return context.getApiSelector().getPathSelector().apply(input.getPath());
            }
        };
    }

    private Iterable<RequestMappingContext> sortedByMethods(List<RequestMappingContext> contexts) {
        return FluentIterable.from(contexts).toSortedList(Orderings.methodComparator());
    }
}

