/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterNameReader
implements ParameterBuilderPlugin {
    @Override
    public void apply(ParameterContext context) {
        String name = this.findParameterNameFromAnnotations(context.resolvedMethodParameter());
        if (Strings.isNullOrEmpty(name)) {
            Optional<String> discoveredName = context.resolvedMethodParameter().defaultName();
            name = discoveredName.isPresent() ? discoveredName.get() : String.format("param%s", context.resolvedMethodParameter().getParameterIndex());
        }
        context.parameterBuilder().name(name).description(name);
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String findParameterNameFromAnnotations(ResolvedMethodParameter methodParameter) {
        return methodParameter.findAnnotation(PathVariable.class).transform(this.pathVariableValue()).or(methodParameter.findAnnotation(ModelAttribute.class).transform(this.modelAttributeValue())).or(methodParameter.findAnnotation(RequestParam.class).transform(this.requestParamValue())).or(methodParameter.findAnnotation(RequestHeader.class).transform(this.requestHeaderValue())).or(methodParameter.findAnnotation(RequestPart.class).transform(this.requestPartValue())).orNull();
    }

    private Function<RequestHeader, String> requestHeaderValue() {
        return new Function<RequestHeader, String>(){

            @Override
            public String apply(RequestHeader input) {
                return input.value();
            }
        };
    }

    private Function<RequestParam, String> requestParamValue() {
        return new Function<RequestParam, String>(){

            @Override
            public String apply(RequestParam input) {
                return input.value();
            }
        };
    }

    private Function<ModelAttribute, String> modelAttributeValue() {
        return new Function<ModelAttribute, String>(){

            @Override
            public String apply(ModelAttribute input) {
                return input.value();
            }
        };
    }

    private Function<PathVariable, String> pathVariableValue() {
        return new Function<PathVariable, String>(){

            @Override
            public String apply(PathVariable input) {
                return input.value();
            }
        };
    }

    private Function<RequestPart, String> requestPartValue() {
        return new Function<RequestPart, String>(){

            @Override
            public String apply(RequestPart input) {
                return input.value();
            }
        };
    }
}

