/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import springfox.documentation.spi.service.ParameterMetadataAccessor;

public class ModelAttributeParameterMetadataAccessor
implements ParameterMetadataAccessor {
    private final List<AnnotatedElement> annotatedElements;
    private final ResolvedType fieldType;
    private final String fieldName;

    public ModelAttributeParameterMetadataAccessor(List<AnnotatedElement> annotatedElements, ResolvedType fieldType, String fieldName) {
        this.annotatedElements = annotatedElements;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
    }

    @Override
    public ResolvedType getFieldType() {
        return this.fieldType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        for (AnnotatedElement each : this.annotatedElements) {
            A annotation = AnnotationUtils.findAnnotation(each, annotationType);
            if (annotation == null) continue;
            return Optional.of(annotation);
        }
        return Optional.absent();
    }
}

