/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.OperationContext;

public class ExpansionContext {
    private final String parentName;
    private final ResolvedType paramType;
    private final OperationContext operationContext;
    private final Set<ResolvedType> seenTypes;

    public ExpansionContext(String parentName, ResolvedType paramType, OperationContext operationContext) {
        this(parentName, paramType, operationContext, Sets.newHashSet());
    }

    private ExpansionContext(String parentName, ResolvedType paramType, OperationContext operationContext, Set<ResolvedType> seenTypes) {
        this.parentName = parentName;
        this.paramType = paramType;
        this.operationContext = operationContext;
        this.seenTypes = Sets.newHashSet(seenTypes);
    }

    public String getParentName() {
        return this.parentName;
    }

    public ResolvedType getParamType() {
        return this.paramType;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public DocumentationContext getDocumentationContext() {
        return this.operationContext.getDocumentationContext();
    }

    public boolean hasSeenType(ResolvedType type) {
        return this.seenTypes.contains(type) || Objects.equal(type, this.paramType);
    }

    public ExpansionContext childContext(String parentName, ResolvedType childType, OperationContext operationContext) {
        HashSet<ResolvedType> childSeenTypes = Sets.newHashSet(this.seenTypes);
        childSeenTypes.add(childType);
        return new ExpansionContext(parentName, childType, operationContext, childSeenTypes);
    }
}

