/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.WebMvcRequestHandler;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

@Component
@Order(value=-2147483648)
public class WebMvcRequestHandlerProvider
implements RequestHandlerProvider {
    private final List<RequestMappingInfoHandlerMapping> handlerMappings;
    private final HandlerMethodResolver methodResolver;

    @Autowired
    public WebMvcRequestHandlerProvider(HandlerMethodResolver methodResolver, List<RequestMappingInfoHandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
        this.methodResolver = methodResolver;
    }

    @Override
    public List<RequestHandler> requestHandlers() {
        return Orderings.byPatternsCondition().sortedCopy(FluentIterable.from(BuilderDefaults.nullToEmptyList(this.handlerMappings)).transformAndConcat(this.toMappingEntries()).transform(this.toRequestHandler()));
    }

    private Function<? super RequestMappingInfoHandlerMapping, Iterable<Map.Entry<RequestMappingInfo, HandlerMethod>>> toMappingEntries() {
        return new Function<RequestMappingInfoHandlerMapping, Iterable<Map.Entry<RequestMappingInfo, HandlerMethod>>>(){

            @Override
            public Iterable<Map.Entry<RequestMappingInfo, HandlerMethod>> apply(RequestMappingInfoHandlerMapping input) {
                return input.getHandlerMethods().entrySet();
            }
        };
    }

    private Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler> toRequestHandler() {
        return new Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler>(){

            @Override
            public WebMvcRequestHandler apply(Map.Entry<RequestMappingInfo, HandlerMethod> input) {
                return new WebMvcRequestHandler(WebMvcRequestHandlerProvider.this.methodResolver, input.getKey(), input.getValue());
            }
        };
    }
}

