/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.plugins.ResolvedMethodParameterEquivalence;

class PathAndParametersEquivalence
extends Equivalence<RequestHandler> {
    private static final ResolvedMethodParameterEquivalence parameterEquivalence = new ResolvedMethodParameterEquivalence();

    PathAndParametersEquivalence() {
    }

    @Override
    protected boolean doEquivalent(RequestHandler a, RequestHandler b) {
        return a.getPatternsCondition().equals(b.getPatternsCondition()) && !Sets.intersection(a.supportedMethods(), b.supportedMethods()).isEmpty() && a.params().equals(b.params()) && Sets.symmetricDifference(this.wrapped(a.getParameters()), this.wrapped(b.getParameters())).isEmpty();
    }

    private Set<Equivalence.Wrapper<ResolvedMethodParameter>> wrapped(List<ResolvedMethodParameter> parameters) {
        return FluentIterable.from(parameters).transform(this.wrappingFunction()).toSet();
    }

    private Function<ResolvedMethodParameter, Equivalence.Wrapper<ResolvedMethodParameter>> wrappingFunction() {
        return new Function<ResolvedMethodParameter, Equivalence.Wrapper<ResolvedMethodParameter>>(){

            @Override
            public Equivalence.Wrapper<ResolvedMethodParameter> apply(ResolvedMethodParameter input) {
                return parameterEquivalence.wrap(input);
            }
        };
    }

    @Override
    protected int doHash(RequestHandler requestHandler) {
        return Objects.hashCode(requestHandler.getPatternsCondition().getPatterns(), requestHandler.supportedMethods(), requestHandler.params(), this.wrapped(requestHandler.getParameters()));
    }
}

