/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ResolvedMethodParameter;

public class CombinedRequestHandler
implements RequestHandler {
    private final RequestHandler first;
    private final RequestHandler second;

    public CombinedRequestHandler(RequestHandler first, RequestHandler second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Class<?> declaringClass() {
        return this.first.declaringClass();
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.first.isAnnotatedWith(annotation) || this.second.isAnnotatedWith(annotation);
    }

    @Override
    public PatternsRequestCondition getPatternsCondition() {
        Sets.SetView<String> patterns = Sets.union(this.first.getPatternsCondition().getPatterns(), this.second.getPatternsCondition().getPatterns());
        return new PatternsRequestCondition(patterns.toArray(new String[patterns.size()]));
    }

    @Override
    public String groupName() {
        return this.first.groupName();
    }

    @Override
    public String getName() {
        return this.first.getName();
    }

    @Override
    public Set<RequestMethod> supportedMethods() {
        return Sets.union(this.first.supportedMethods(), this.second.supportedMethods());
    }

    @Override
    public Set<? extends MediaType> produces() {
        return Sets.union(BuilderDefaults.nullToEmptySet(this.first.produces()), BuilderDefaults.nullToEmptySet(this.second.produces()));
    }

    @Override
    public Set<? extends MediaType> consumes() {
        return Sets.union(BuilderDefaults.nullToEmptySet(this.first.consumes()), BuilderDefaults.nullToEmptySet(this.second.consumes()));
    }

    @Override
    public Set<NameValueExpression<String>> headers() {
        return Sets.union(this.first.headers(), this.second.headers());
    }

    @Override
    public Set<NameValueExpression<String>> params() {
        return this.first.params();
    }

    @Override
    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return this.first.findAnnotation(annotation).or(this.second.findAnnotation(annotation));
    }

    @Override
    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.consumes(), this.produces());
    }

    @Override
    public List<ResolvedMethodParameter> getParameters() {
        return this.first.getParameters();
    }

    @Override
    public ResolvedType getReturnType() {
        return this.first.getReturnType();
    }

    @Override
    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return this.first.findControllerAnnotation(annotation).or(this.second.findControllerAnnotation(annotation));
    }

    @Override
    public RequestMappingInfo getRequestMapping() {
        return this.first.getRequestMapping();
    }

    @Override
    public HandlerMethod getHandlerMethod() {
        return this.second.getHandlerMethod();
    }

    @Override
    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler(this, other);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CombinedRequestHandler{");
        sb.append("first key=").append(this.first.key());
        sb.append("second key=").append(this.second.key());
        sb.append("combined key=").append(this.key());
        sb.append('}');
        return sb.toString();
    }
}

