/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.JaxbPresentInClassPathCondition;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Conditional(value={JaxbPresentInClassPathCondition.class})
public class XmlPropertyPlugin
implements ModelPropertyBuilderPlugin {
    @Override
    public void apply(ModelPropertyContext context) {
        Optional<Object> elementAnnotation = Optional.absent();
        Optional<Object> attributeAnnotation = Optional.absent();
        if (context.getAnnotatedElement().isPresent()) {
            elementAnnotation = elementAnnotation.or(XmlPropertyPlugin.findAnnotation(context.getAnnotatedElement().get(), XmlElement.class));
            attributeAnnotation = attributeAnnotation.or(XmlPropertyPlugin.findAnnotation(context.getAnnotatedElement().get(), XmlAttribute.class));
        }
        if (context.getBeanPropertyDefinition().isPresent()) {
            elementAnnotation = elementAnnotation.or(Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), XmlElement.class));
            attributeAnnotation = attributeAnnotation.or(Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), XmlAttribute.class));
        }
        if (elementAnnotation.isPresent() && context.getBeanPropertyDefinition().isPresent()) {
            Optional<XmlElementWrapper> wrapper = Annotations.findPropertyAnnotation(context.getBeanPropertyDefinition().get(), XmlElementWrapper.class);
            context.getBuilder().xml(new Xml().attribute(false).namespace(this.defaultToNull(((XmlElement)elementAnnotation.get()).namespace())).name(this.wrapperName(wrapper, elementAnnotation)).wrapped(wrapper.isPresent()));
        } else if (attributeAnnotation.isPresent()) {
            context.getBuilder().xml(new Xml().attribute(true).namespace(this.defaultToNull(((XmlAttribute)attributeAnnotation.get()).namespace())).name(this.attributeName(attributeAnnotation)).wrapped(false));
        }
    }

    public static <T extends Annotation> Optional<T> findAnnotation(AnnotatedElement annotated, Class<T> annotation) {
        return Optional.fromNullable(AnnotationUtils.getAnnotation(annotated, annotation));
    }

    private String wrapperName(Optional<XmlElementWrapper> wrapper, Optional<XmlElement> element) {
        if (wrapper.isPresent()) {
            return Optional.fromNullable(this.defaultToNull(Strings.emptyToNull(wrapper.get().name()))).or(Optional.fromNullable(this.elementName(element))).orNull();
        }
        return this.elementName(element);
    }

    private String elementName(Optional<XmlElement> element) {
        if (element.isPresent()) {
            return this.defaultToNull(Strings.emptyToNull(element.get().name()));
        }
        return null;
    }

    private String attributeName(Optional<XmlAttribute> attribute) {
        if (attribute.isPresent()) {
            return this.defaultToNull(Strings.emptyToNull(attribute.get().name()));
        }
        return null;
    }

    private String defaultToNull(String value) {
        return "##default".equalsIgnoreCase(value) ? null : value;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

