/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeBindings;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WildcardType {
    private WildcardType() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasWildcards(ResolvedType type) {
        return Iterables.any(type.getTypeBindings().getTypeParameters(), WildcardType.thatAreWildcards());
    }

    public static boolean exactMatch(ResolvedType first, ResolvedType second) {
        return first.equals(second);
    }

    public static boolean wildcardMatch(ResolvedType toMatch, ResolvedType wildcardType) {
        if (!toMatch.getErasedType().equals(wildcardType.getErasedType())) {
            return false;
        }
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        TypeBindings bindingsToMatch = toMatch.getTypeBindings();
        if (wildcardTypeBindings.size() != bindingsToMatch.size()) {
            return false;
        }
        for (int index = 0; index < bindingsToMatch.size(); ++index) {
            ResolvedType wildcardTypeBindingsBoundType = wildcardTypeBindings.getBoundType(index);
            ResolvedType bindingsToMatchBoundType = bindingsToMatch.getBoundType(index);
            if (WildcardType.class.equals(wildcardTypeBindingsBoundType.getErasedType()) || WildcardType.wildcardMatch(bindingsToMatchBoundType, wildcardTypeBindingsBoundType)) continue;
            return false;
        }
        return true;
    }

    static ResolvedType replaceWildcardsFrom(Iterable<ResolvedType> replaceables, ResolvedType wildcardType) {
        Iterator<ResolvedType> replaceableIterator = replaceables.iterator();
        return WildcardType.breadthFirstReplace(replaceableIterator, wildcardType);
    }

    static List<ResolvedType> collectReplaceables(ResolvedType replacingType, ResolvedType wildcardType) {
        return WildcardType.breadthFirstSearch(replacingType, wildcardType);
    }

    private static Predicate<ResolvedType> thatAreWildcards() {
        return new Predicate<ResolvedType>(){

            @Override
            public boolean apply(ResolvedType input) {
                return WildcardType.isWildcardType(input) || WildcardType.hasWildcards(input);
            }
        };
    }

    private static boolean isWildcardType(ResolvedType input) {
        return WildcardType.class.equals(input.getErasedType());
    }

    private static ResolvedType breadthFirstReplace(Iterator<ResolvedType> replaceableIterator, ResolvedType wildcardType) {
        if (WildcardType.isWildcardType(wildcardType)) {
            if (replaceableIterator.hasNext()) {
                return replaceableIterator.next();
            }
            throw new IllegalStateException("Expecting the same number of wildcard types as the replaceables");
        }
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        ArrayList<ResolvedType> bindings = Lists.newArrayList();
        for (int index = 0; index < wildcardTypeBindings.size(); ++index) {
            if (WildcardType.isWildcardType(wildcardTypeBindings.getBoundType(index))) {
                if (replaceableIterator.hasNext()) {
                    bindings.add(replaceableIterator.next());
                    continue;
                }
                throw new IllegalStateException("Count of wildcards to candidates do not match");
            }
            bindings.add(WildcardType.breadthFirstReplace(replaceableIterator, wildcardTypeBindings.getBoundType(index)));
        }
        return new TypeResolver().resolve(wildcardType.getErasedType(), Iterables.toArray(bindings, Type.class));
    }

    private static List<ResolvedType> breadthFirstSearch(ResolvedType replacingType, ResolvedType wildcardType) {
        TypeBindings wildcardTypeBindings = wildcardType.getTypeBindings();
        TypeBindings replacingBindings = replacingType.getTypeBindings();
        ArrayList<ResolvedType> bindings = Lists.newArrayList();
        int index = 0;
        for (TypeVariable<Class<?>> each : replacingType.getErasedType().getTypeParameters()) {
            ResolvedType boundType = Optional.fromNullable(replacingBindings.findBoundType(each.getName())).or(new TypeResolver().resolve((Type)((Object)Object.class), new Type[0]));
            if (WildcardType.isWildcardType(wildcardTypeBindings.getBoundType(index))) {
                bindings.add(boundType);
            } else {
                bindings.addAll(WildcardType.breadthFirstSearch(boundType, wildcardTypeBindings.getBoundType(index)));
            }
            ++index;
        }
        return bindings;
    }
}

