/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.AllowableValues;

public class ModelRef
implements ModelReference {
    private final String type;
    private final boolean isMap;
    private final Optional<ModelReference> itemModel;
    private final Optional<AllowableValues> allowableValues;

    public ModelRef(String type) {
        this(type, null, null);
    }

    public ModelRef(String type, ModelReference itemType) {
        this(type, itemType, false);
    }

    public ModelRef(String type, ModelReference itemType, AllowableValues allowableValues) {
        this(type, itemType, allowableValues, false);
    }

    public ModelRef(String type, AllowableValues allowableValues) {
        this(type, null, allowableValues);
    }

    public ModelRef(String type, ModelReference itemType, boolean isMap) {
        this(type, itemType, null, isMap);
    }

    public ModelRef(String type, ModelReference itemModel, AllowableValues allowableValues, boolean isMap) {
        this.type = type;
        this.isMap = isMap;
        this.allowableValues = Optional.fromNullable(allowableValues);
        this.itemModel = Optional.fromNullable(itemModel);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isCollection() {
        return this.itemModel.isPresent() && !this.isMap;
    }

    @Override
    public boolean isMap() {
        return this.itemModel.isPresent() && this.isMap;
    }

    @Override
    public String getItemType() {
        return this.itemModel.transform(this.toName()).orNull();
    }

    @Override
    public AllowableValues getAllowableValues() {
        return this.allowableValues.orNull();
    }

    @Override
    public Optional<ModelReference> itemModel() {
        return this.itemModel;
    }

    private Function<? super ModelReference, String> toName() {
        return new Function<ModelReference, String>(){

            @Override
            public String apply(ModelReference input) {
                return input.getType();
            }
        };
    }
}

