/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

public class JaxbPresentInClassPathCondition
implements Condition {
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return JaxbPresentInClassPathCondition.isPresent("javax.xml.bind.annotation.XmlElement", context.getClassLoader());
    }

    private static boolean isPresent(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

