/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import springfox.documentation.schema.Enums;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;

public class BuilderDefaults {
    private BuilderDefaults() {
        throw new UnsupportedOperationException();
    }

    public static <T> T defaultIfAbsent(T newValue, T defaultValue) {
        return Optional.fromNullable(newValue).or(Optional.fromNullable(defaultValue)).orNull();
    }

    public static <T> List<T> nullToEmptyList(Collection<T> newValue) {
        if (newValue == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(newValue);
    }

    public static <K, V> Map<K, V> nullToEmptyMap(Map<K, V> newValue) {
        if (newValue == null) {
            return Maps.newHashMap();
        }
        return newValue;
    }

    public static <K, V> Multimap<K, V> nullToEmptyMultimap(Multimap<K, V> newValue) {
        if (newValue == null) {
            return LinkedListMultimap.create();
        }
        return newValue;
    }

    public static <T> Set<T> nullToEmptySet(Set<T> newValue) {
        if (newValue == null) {
            return Sets.newHashSet();
        }
        return newValue;
    }

    public static ResolvedType replaceIfMoreSpecific(ResolvedType replacement, ResolvedType defaultValue) {
        ResolvedType toReturn = BuilderDefaults.defaultIfAbsent(replacement, defaultValue);
        if (BuilderDefaults.isObject(replacement) && BuilderDefaults.isNotObject(defaultValue)) {
            return defaultValue;
        }
        return toReturn;
    }

    public static <T> List<T> nullVarArgsToEmptyList(T ... args) {
        if (args == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(args);
    }

    private static boolean isNotObject(ResolvedType defaultValue) {
        return defaultValue != null && !Object.class.equals(defaultValue.getErasedType());
    }

    private static boolean isObject(ResolvedType replacement) {
        return replacement != null && Object.class.equals(replacement.getErasedType());
    }

    public static AllowableValues emptyToNull(AllowableValues newValue, AllowableValues current) {
        if (newValue != null) {
            if (newValue instanceof AllowableListValues) {
                return BuilderDefaults.defaultIfAbsent(Enums.emptyListValuesToNull((AllowableListValues)newValue), current);
            }
            return BuilderDefaults.defaultIfAbsent(newValue, current);
        }
        return current;
    }
}

