/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class MinMaxAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    @Override
    public void apply(ModelPropertyContext context) {
        Optional<Min> min = this.extractMin(context);
        Optional<Max> max = this.extractMax(context);
        context.getBuilder().allowableValues(RangeAnnotations.allowableRange(min, max));
    }

    @VisibleForTesting
    Optional<Min> extractMin(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, Min.class).or(Validators.annotationFromField(context, Min.class));
    }

    @VisibleForTesting
    Optional<Max> extractMax(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, Max.class).or(Validators.annotationFromField(context, Max.class));
    }
}

