/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.spi.service.contexts.ParameterContext;

public class Validators {
    public static final int BEAN_VALIDATOR_PLUGIN_ORDER = -2147483148;

    private Validators() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Annotation> Optional<T> extractAnnotation(ModelPropertyContext context, Class<T> annotationType) {
        return Validators.annotationFromBean(context, annotationType).or(Validators.annotationFromField(context, annotationType));
    }

    public static <T extends Annotation> Optional<T> annotationFromBean(ModelPropertyContext context, Class<T> annotationType) {
        Optional<BeanPropertyDefinition> propertyDefinition = context.getBeanPropertyDefinition();
        Optional notNull = Optional.absent();
        if (propertyDefinition.isPresent()) {
            Optional<Method> getter = Validators.extractGetterFromPropertyDefinition(propertyDefinition.get());
            Optional<Field> field = Validators.extractFieldFromPropertyDefinition(propertyDefinition.get());
            notNull = Validators.findAnnotation(getter, annotationType).or(Validators.findAnnotation(field, annotationType));
        }
        return notNull;
    }

    public static <T extends Annotation> Optional<T> annotationFromField(ModelPropertyContext context, Class<T> annotationType) {
        return Validators.findAnnotation(context.getAnnotatedElement(), annotationType);
    }

    public static <T extends Annotation> Optional<T> annotationFromParameter(ParameterContext context, Class<T> annotationType) {
        ResolvedMethodParameter methodParam = context.resolvedMethodParameter();
        return methodParam.findAnnotation(annotationType);
    }

    private static Optional<Field> extractFieldFromPropertyDefinition(BeanPropertyDefinition propertyDefinition) {
        if (propertyDefinition.getField() != null) {
            return Optional.fromNullable(propertyDefinition.getField().getAnnotated());
        }
        return Optional.absent();
    }

    private static Optional<Method> extractGetterFromPropertyDefinition(BeanPropertyDefinition propertyDefinition) {
        if (propertyDefinition.getGetter() != null) {
            return Optional.fromNullable(propertyDefinition.getGetter().getMember());
        }
        return Optional.absent();
    }

    private static <T extends Annotation> Optional<T> findAnnotation(Optional<? extends AnnotatedElement> annotatedElement, Class<T> annotationType) {
        if (annotatedElement.isPresent()) {
            return Optional.fromNullable(AnnotationUtils.findAnnotation(annotatedElement.get(), annotationType));
        }
        return Optional.absent();
    }
}

