/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.GetterType;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;

public class ConstrainedGetterBuilder {
    private static final Log log = LoggerFactory.make();

    private ConstrainedGetterBuilder() {
    }

    public static Set<ConstrainedExecutable> buildConstrainedGetters(List<GetterType> getterList, Class<?> beanClass, String defaultPackage, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        HashSet<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        ArrayList<String> alreadyProcessedGetterNames = CollectionHelper.newArrayList();
        for (GetterType getterType : getterList) {
            String getterName = getterType.getName();
            Method getter = ConstrainedGetterBuilder.findGetter(beanClass, getterName, alreadyProcessedGetterNames);
            ExecutableConstraintLocation constraintLocation = new ExecutableConstraintLocation(getter);
            HashSet metaConstraints = CollectionHelper.newHashSet();
            for (ConstraintType constraint : getterType.getConstraint()) {
                MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.METHOD, defaultPackage, constraintHelper);
                metaConstraints.add(metaConstraint);
            }
            Map<Class<?>, Class<?>> groupConversions = GroupConversionBuilder.buildGroupConversionMap(getterType.getConvertGroup(), defaultPackage);
            ConstrainedExecutable constrainedGetter = new ConstrainedExecutable(ConfigurationSource.XML, constraintLocation, Collections.emptyList(), Collections.emptySet(), metaConstraints, groupConversions, getterType.getValid() != null);
            constrainedExecutables.add(constrainedGetter);
            if (getterType.getIgnoreAnnotations() == null) continue;
            annotationProcessingOptions.ignoreConstraintAnnotationsOnMember(getter, getterType.getIgnoreAnnotations());
        }
        return constrainedExecutables;
    }

    private static Method findGetter(Class<?> beanClass, String getterName, List<String> alreadyProcessedGetterNames) {
        if (alreadyProcessedGetterNames.contains(getterName)) {
            throw log.getIsDefinedTwiceInMappingXmlForBeanException(getterName, beanClass.getName());
        }
        alreadyProcessedGetterNames.add(getterName);
        Method method = ReflectionHelper.getMethodFromPropertyName(beanClass, (String)getterName);
        if (method == null) {
            throw log.getBeanDoesNotContainThePropertyException(beanClass.getName(), getterName);
        }
        return method;
    }
}

