/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.web;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSort;
import com.github.xiaoymin.knife4j.annotations.ApiSort;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.github.xiaoymin.knife4j.spring.common.SwaggerBootstrapUiHostNameProvider;
import com.github.xiaoymin.knife4j.spring.model.MarkdownFiles;
import com.github.xiaoymin.knife4j.spring.model.RestHandlerMapping;
import com.github.xiaoymin.knife4j.spring.model.SwaggerBootstrapUi;
import com.github.xiaoymin.knife4j.spring.model.SwaggerBootstrapUiPath;
import com.github.xiaoymin.knife4j.spring.model.SwaggerBootstrapUiTag;
import com.github.xiaoymin.knife4j.spring.model.SwaggerExt;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.Swagger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UriComponents;
import springfox.documentation.RequestHandler;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.WebMvcRequestHandler;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger.common.HostNameProvider;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Controller
@ApiIgnore
public class Knife4jController {
    public static final String DEFAULT_SORT_URL = "/v2/api-docs-ext";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private static final Logger LOGGER = LoggerFactory.getLogger(Knife4jController.class);
    private final ServiceModelToSwagger2Mapper mapper;
    private final DocumentationCache documentationCache;
    private final JsonSerializer jsonSerializer;
    private final String hostNameOverride;
    private final List<RequestHandlerProvider> handlerProviders;
    private final MarkdownFiles markdownFiles;
    private List<RestHandlerMapping> globalHandlerMappings = new ArrayList<RestHandlerMapping>();
    private final RequestMethod[] globalRequestMethods = new RequestMethod[]{RequestMethod.POST, RequestMethod.GET, RequestMethod.PUT, RequestMethod.DELETE, RequestMethod.PATCH, RequestMethod.OPTIONS, RequestMethod.HEAD};

    @Autowired
    public Knife4jController(Environment environment2, ServiceModelToSwagger2Mapper mapper, DocumentationCache documentationCache, JsonSerializer jsonSerializer, List<RequestHandlerProvider> handlerProviders, ObjectProvider<MarkdownFiles> markdownFilesObjectProvider) {
        this.mapper = mapper;
        this.documentationCache = documentationCache;
        this.jsonSerializer = jsonSerializer;
        this.hostNameOverride = environment2.getProperty("springfox.documentation.swagger.v2.host", "DEFAULT");
        this.handlerProviders = handlerProviders;
        this.markdownFiles = markdownFilesObjectProvider.getIfAvailable();
    }

    private Function<RequestHandlerProvider, ? extends Iterable<RequestHandler>> handlers() {
        return new RequestHandlerFunction();
    }

    @RequestMapping(value={"/v2/api-docs-ext"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<Json> apiSorts(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest request) {
        UriComponents uriComponents;
        Swagger swagger;
        Documentation documentation;
        block5: {
            String groupName = Optional.fromNullable(swaggerGroup).or("default");
            documentation = this.documentationCache.documentationByGroup(groupName);
            if (documentation == null) {
                LOGGER.warn("Unable to find specification for group {},use default", (Object)groupName);
                documentation = this.documentationCache.documentationByGroup("default");
                if (documentation == null) {
                    LOGGER.warn("Unable to find specification for group default");
                    return new ResponseEntity<Json>(HttpStatus.NOT_FOUND);
                }
            }
            swagger = this.mapper.mapDocumentation(documentation);
            uriComponents = null;
            try {
                uriComponents = HostNameProvider.componentsFrom(request, swagger.getBasePath());
            }
            catch (Throwable e) {
                String msg;
                LOGGER.error(e.getClass().getName() + ":" + e.getMessage());
                if (!(e instanceof ClassNotFoundException) && !(e instanceof NoClassDefFoundError) || (msg = e.getMessage()) == null || "".equals(msg) || !msg.endsWith("HostNameProvider")) break block5;
                uriComponents = SwaggerBootstrapUiHostNameProvider.componentsFrom(request, swagger.getBasePath());
            }
        }
        swagger.basePath(Strings.isNullOrEmpty(uriComponents.getPath()) ? "/" : uriComponents.getPath());
        if (Strings.isNullOrEmpty(swagger.getHost())) {
            swagger.host(this.hostName(uriComponents));
        }
        SwaggerExt swaggerExt = new SwaggerExt(swagger);
        swaggerExt.setSwaggerBootstrapUi(this.initSwaggerBootstrapUi(request, documentation, swaggerExt));
        return new ResponseEntity<Json>(this.jsonSerializer.toJson(swaggerExt), HttpStatus.OK);
    }

    private SwaggerBootstrapUi initSwaggerBootstrapUi(HttpServletRequest request, Documentation documentation, SwaggerExt swaggerExt) {
        SwaggerBootstrapUi swaggerBootstrapUi = new SwaggerBootstrapUi();
        WebApplicationContext wc = WebApplicationContextUtils.getWebApplicationContext(request.getServletContext());
        if (wc == null) {
            String msg = "WebApplicationContext is Empty~!,Enable SwaggerBootstrapUi fun fail~!";
            LOGGER.warn(msg);
            swaggerBootstrapUi.setErrorMsg(msg);
            return swaggerBootstrapUi;
        }
        Iterator<Tag> tags = documentation.getTags().iterator();
        this.initGlobalRequestMappingArray(swaggerExt);
        ArrayList<SwaggerBootstrapUiTag> targetTagLists = Lists.newArrayList();
        ArrayList<SwaggerBootstrapUiPath> targetPathLists = Lists.newArrayList();
        while (tags.hasNext()) {
            Tag sourceTag = tags.next();
            String tagName = sourceTag.getName();
            int order = Integer.MAX_VALUE;
            SwaggerBootstrapUiTag tag = new SwaggerBootstrapUiTag(order);
            tag.name(tagName).description(sourceTag.getDescription());
            Api tagApi = null;
            RestHandlerMapping tagMapping = null;
            for (RestHandlerMapping rhm : this.globalHandlerMappings) {
                Api api = rhm.getBeanType().getAnnotation(Api.class);
                if (api != null) {
                    if (api.tags() != null && api.tags().length > 0) {
                        if (Lists.newArrayList(api.tags()).contains(tagName)) {
                            tagApi = api;
                            tagMapping = rhm;
                            this.createPathInstance(rhm, targetPathLists);
                            continue;
                        }
                        String firstTag = api.tags()[0];
                        if (!StringUtils.isEmpty(firstTag) || !this.checkExists(tagName, rhm.getBeanType())) continue;
                        tagApi = api;
                        tagMapping = rhm;
                        this.createPathInstance(rhm, targetPathLists);
                        continue;
                    }
                    if (!this.checkExists(tagName, rhm.getBeanType())) continue;
                    if (!StringUtils.isEmpty(api.value())) {
                        tag.name(api.value());
                    }
                    tagApi = api;
                    tagMapping = rhm;
                    this.createPathInstance(rhm, targetPathLists);
                    continue;
                }
                if (!this.checkExists(tagName, rhm.getBeanType())) continue;
                tagMapping = rhm;
                this.createPathInstance(rhm, targetPathLists);
            }
            if (tagMapping != null) {
                tag.setOrder(this.getRestTagOrder(tagMapping.getBeanType(), tagApi));
                String author = this.getRestTagAuthor(tagMapping.getBeanType());
                if (author != null && !"".equalsIgnoreCase(author)) {
                    tag.setAuthor(author);
                }
            }
            targetTagLists.add(tag);
        }
        Collections.sort(targetTagLists, new Knife4jTagComparator());
        Collections.sort(targetPathLists, new Knife4jPathComparator());
        swaggerBootstrapUi.setTagSortLists(targetTagLists);
        swaggerBootstrapUi.setPathSortLists(targetPathLists);
        if (this.markdownFiles != null) {
            swaggerBootstrapUi.setMarkdownFiles(this.markdownFiles.getMarkdownFiles());
        }
        return swaggerBootstrapUi;
    }

    private void initGlobalRequestMappingArray(SwaggerExt swaggerExt) {
        if (this.globalHandlerMappings.size() == 0) {
            String parentPath = "";
            if (!StringUtils.isEmpty(swaggerExt.getBasePath()) && !"/".equals(swaggerExt.getBasePath())) {
                parentPath = parentPath + swaggerExt.getBasePath();
            }
            try {
                ImmutableList requestHandlers = FluentIterable.from(this.handlerProviders).transformAndConcat(this.handlers()).toList();
                for (RequestHandler requestHandler : requestHandlers) {
                    if (!(requestHandler instanceof WebMvcRequestHandler)) continue;
                    WebMvcRequestHandler webMvcRequestHandler = (WebMvcRequestHandler)requestHandler;
                    Set<String> patterns = webMvcRequestHandler.getRequestMapping().getPatternsCondition().getPatterns();
                    Set<RequestMethod> restMethods = webMvcRequestHandler.getRequestMapping().getMethodsCondition().getMethods();
                    HandlerMethod handlerMethod = webMvcRequestHandler.getHandlerMethod();
                    Class<?> controllerClazz = ClassUtils.getUserClass(handlerMethod.getBeanType());
                    Method method = ClassUtils.getMostSpecificMethod(handlerMethod.getMethod(), controllerClazz);
                    for (String url : patterns) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("url:" + url + "\r\nclass:" + controllerClazz.toString() + "\r\nmethod:" + method.toString());
                        }
                        this.globalHandlerMappings.add(new RestHandlerMapping(parentPath + url, controllerClazz, method, restMethods));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    private void initGlobalRequestMappingArray(WebApplicationContext wc, SwaggerExt swaggerExt) {
        if (this.globalHandlerMappings.size() == 0) {
            Map<String, HandlerMapping> requestMappings;
            String parentPath = "";
            if (!StringUtils.isEmpty(swaggerExt.getBasePath()) && !"/".equals(swaggerExt.getBasePath())) {
                parentPath = parentPath + swaggerExt.getBasePath();
            }
            if ((requestMappings = BeanFactoryUtils.beansOfTypeIncludingAncestors(wc, HandlerMapping.class, true, false)) != null) {
                for (HandlerMapping handlerMapping : requestMappings.values()) {
                    if (!(handlerMapping instanceof RequestMappingHandlerMapping)) continue;
                    RequestMappingHandlerMapping rmhMapping = (RequestMappingHandlerMapping)handlerMapping;
                    Map handlerMethods = rmhMapping.getHandlerMethods();
                    for (RequestMappingInfo rmi : handlerMethods.keySet()) {
                        PatternsRequestCondition prc = rmi.getPatternsCondition();
                        Set<RequestMethod> restMethods = rmi.getMethodsCondition().getMethods();
                        Set<String> patterns = prc.getPatterns();
                        HandlerMethod handlerMethod = handlerMethods.get(rmi);
                        for (String url : patterns) {
                            Class<?> clazz = ClassUtils.getUserClass(handlerMethod.getBeanType());
                            Method method = ClassUtils.getMostSpecificMethod(handlerMethod.getMethod(), clazz);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("url:" + url + "\r\nclass:" + clazz.toString() + "\r\nmethod:" + method.toString());
                            }
                            this.globalHandlerMappings.add(new RestHandlerMapping(parentPath + url, clazz, method, restMethods));
                        }
                    }
                }
            }
        }
    }

    private void createPathInstance(RestHandlerMapping rhm, List<SwaggerBootstrapUiPath> targetPathLists) {
        if (rhm.getRequestMethods() == null || rhm.getRequestMethods().size() == 0) {
            for (RequestMethod requestMethod : this.globalRequestMethods) {
                targetPathLists.add(new SwaggerBootstrapUiPath(rhm.getUrl(), requestMethod.name().toUpperCase(), this.getRestMethodOrder(rhm.getBeanOfMethod())));
            }
        } else {
            for (RequestMethod requestMethod : rhm.getRequestMethods()) {
                targetPathLists.add(new SwaggerBootstrapUiPath(rhm.getUrl(), requestMethod.name().toUpperCase(), this.getRestMethodOrder(rhm.getBeanOfMethod())));
            }
        }
    }

    private String getRestTagAuthor(Class<?> aClass) {
        ApiSupport apiSupport;
        if (aClass != null && (apiSupport = ClassUtils.getUserClass(aClass).getAnnotation(ApiSupport.class)) != null) {
            return apiSupport.author();
        }
        return null;
    }

    private int getRestTagOrder(Class<?> aClass, Api api) {
        int post;
        int order = Integer.MAX_VALUE;
        order = api != null ? ((post = api.position()) == 0 ? this.findOrder(aClass) : post) : this.findOrder(aClass);
        return order;
    }

    private Integer findOrder(Class<?> aClass) {
        int order = Integer.MAX_VALUE;
        if (aClass != null) {
            ApiSort annotation = ClassUtils.getUserClass(aClass).getAnnotation(ApiSort.class);
            if (annotation != null) {
                order = annotation.value();
            } else {
                ApiSupport apiSupport = ClassUtils.getUserClass(aClass).getAnnotation(ApiSupport.class);
                if (apiSupport != null) {
                    order = apiSupport.order();
                }
            }
        }
        return order;
    }

    private int getRestMethodOrder(Method target) {
        int pathOrder = Integer.MAX_VALUE;
        ApiOperation apiOperation = target.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            if (apiOperation.position() != 0) {
                pathOrder = apiOperation.position();
            } else {
                ApiOperationSort apiOperationSort = target.getAnnotation(ApiOperationSort.class);
                if (apiOperationSort != null) {
                    pathOrder = apiOperationSort.value();
                }
            }
        } else {
            ApiOperationSort apiOperationSort = target.getAnnotation(ApiOperationSort.class);
            if (apiOperationSort != null) {
                pathOrder = apiOperationSort.value();
            }
        }
        return pathOrder;
    }

    private boolean checkExists(String tagName, Class<?> aClass) {
        String regexStr;
        Pattern pattern;
        boolean flag = false;
        if (!StringUtils.isEmpty(tagName) && (pattern = Pattern.compile(regexStr = tagName.replaceAll("\\-", ".*?"), 2)).matcher(aClass.getSimpleName()).matches()) {
            flag = true;
        }
        return flag;
    }

    private String hostName(UriComponents uriComponents) {
        if ("DEFAULT".equals(this.hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return this.hostNameOverride;
    }

    static class RequestHandlerFunction
    implements Function<RequestHandlerProvider, Iterable<RequestHandler>> {
        RequestHandlerFunction() {
        }

        @Override
        public Iterable<RequestHandler> apply(RequestHandlerProvider input) {
            return input.requestHandlers();
        }
    }

    static class Knife4jPathComparator
    implements Comparator<SwaggerBootstrapUiPath> {
        Knife4jPathComparator() {
        }

        @Override
        public int compare(SwaggerBootstrapUiPath o1, SwaggerBootstrapUiPath o2) {
            return o1.getOrder().compareTo(o2.getOrder());
        }
    }

    static class Knife4jTagComparator
    implements Comparator<SwaggerBootstrapUiTag> {
        Knife4jTagComparator() {
        }

        @Override
        public int compare(SwaggerBootstrapUiTag o1, SwaggerBootstrapUiTag o2) {
            return o1.getOrder().compareTo(o2.getOrder());
        }
    }
}

