/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSort;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.spring.plugin.AbstractOperationBuilderPlugin;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483548)
public class OperationOrderBuilderPlugin
extends AbstractOperationBuilderPlugin {
    @Override
    public void apply(OperationContext context) {
        int posit;
        Optional<ApiOperation> api = context.findAnnotation(ApiOperation.class);
        int position = api.isPresent() ? ((posit = api.get().position()) != 0 ? posit : this.findPosition(context)) : this.findPosition(context);
        context.operationBuilder().extensions(Lists.newArrayList(new StringVendorExtension("x-order", String.valueOf(position))));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private int findPosition(OperationContext context) {
        int position = Integer.MAX_VALUE;
        Optional<ApiOperationSort> apiOperationSortOptional = context.findAnnotation(ApiOperationSort.class);
        if (apiOperationSortOptional.isPresent()) {
            position = apiOperationSortOptional.get().value();
        } else {
            Optional<ApiOperationSupport> apso = context.findAnnotation(ApiOperationSupport.class);
            if (apso.isPresent() && apso.get().order() != 0) {
                position = apso.get().order();
            }
        }
        return position;
    }
}

