/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.spring.plugin.AbstractOperationBuilderPlugin;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ListVendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483546)
public class OperationIgnoreParameterPlugin
extends AbstractOperationBuilderPlugin {
    public static final String IGNORE_PARAMETER_EXTENSION_NAME = "x-ignoreParameters";
    public static final String INCLUDE_PARAMETER_EXTENSION_NAME = "x-includeParameters";

    @Override
    public void apply(OperationContext context) {
        Optional<ApiOperationSupport> apiOperationSupportOptional = context.findAnnotation(ApiOperationSupport.class);
        if (apiOperationSupportOptional.isPresent()) {
            ApiOperationSupport apiOperationSupport = apiOperationSupportOptional.get();
            this.addExtensionParameters(apiOperationSupport.ignoreParameters(), IGNORE_PARAMETER_EXTENSION_NAME, context);
            this.addExtensionParameters(apiOperationSupport.includeParameters(), INCLUDE_PARAMETER_EXTENSION_NAME, context);
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void addExtensionParameters(String[] params, String extensionName, OperationContext context) {
        if (params != null && params.length > 0) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String ignore : params) {
                if (ignore == null || "".equals(ignore) || "null".equals(ignore)) continue;
                map.put(ignore, true);
            }
            if (map.size() > 0) {
                ArrayList<HashMap<String, Boolean>> maps = new ArrayList<HashMap<String, Boolean>>();
                maps.add(map);
                ListVendorExtension listVendorExtension = new ListVendorExtension(extensionName, maps);
                context.operationBuilder().extensions(Lists.newArrayList(listVendorExtension));
            }
        }
    }
}

