/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.fasterxml.classmate.TypeResolver;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicParameters;
import com.github.xiaoymin.knife4j.core.util.CommonUtils;
import com.github.xiaoymin.knife4j.spring.util.ByteUtils;
import com.google.common.base.Optional;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
@Order(value=-2147483547)
public class OperationDynamicModelProvider
implements OperationModelsProviderPlugin {
    static Logger logger = LoggerFactory.getLogger(OperationDynamicModelProvider.class);
    @Autowired
    private TypeResolver typeResolver;
    private final Map<String, String> cacheGenModelMaps = new HashMap<String, String>();

    @Override
    public void apply(RequestMappingContext context) {
        List<ResolvedMethodParameter> parameterTypes = context.getParameters();
        if (parameterTypes != null && parameterTypes.size() > 0) {
            for (ResolvedMethodParameter parameterType : parameterTypes) {
                if (!parameterType.hasParameterAnnotation(RequestBody.class) || !Map.class.isAssignableFrom(parameterType.getParameterType().getErasedType()) && parameterType.getParameterType().getErasedType().getName() != "com.google.gson.JsonObject") continue;
                Optional<ApiOperationSupport> supportOptional = context.findAnnotation(ApiOperationSupport.class);
                if (supportOptional.isPresent()) {
                    ApiOperationSupport support = supportOptional.get();
                    this.collectDynamicParameter(support.params(), context);
                    continue;
                }
                Optional<DynamicParameters> dynamicParametersOptional = context.findAnnotation(DynamicParameters.class);
                if (!dynamicParametersOptional.isPresent()) continue;
                this.collectDynamicParameter(dynamicParametersOptional.get(), context);
            }
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void collectDynamicParameter(DynamicParameters dynamicParameters, RequestMappingContext context) {
        if (dynamicParameters != null) {
            String name = dynamicParameters.name();
            if (name == null || "".equals(name)) {
                name = this.genClassName(context);
            }
            if (this.cacheGenModelMaps.containsKey(name)) {
                name = this.genClassName(context);
            }
            name = name.replaceAll("[_-]", "");
            DynamicParameter[] dynamics = dynamicParameters.properties();
            if (dynamics != null && dynamics.length > 0) {
                this.cacheGenModelMaps.put(name, name);
                name = context.getGroupName().replaceAll("[_-]", "") + "." + name;
                Class<?> clazz = ByteUtils.createDynamicModelClass(name, dynamics);
                if (clazz != null) {
                    context.operationModelsBuilder().addInputParam(this.typeResolver.resolve(clazz, new Type[0]));
                }
            }
        }
    }

    public String genClassName(RequestMappingContext context) {
        String name = context.getName();
        return CommonUtils.genSupperName(name);
    }
}

