/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.spring.plugin.AbstractOperationBuilderPlugin;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483547)
public class OperationAuthorBuilderPlugin
extends AbstractOperationBuilderPlugin {
    @Override
    public void apply(OperationContext context) {
        String author;
        Optional<ApiOperationSupport> apiOperationSupportOptional = context.findAnnotation(ApiOperationSupport.class);
        if (apiOperationSupportOptional.isPresent() && (author = apiOperationSupportOptional.get().author()) != null && !"".equals(author) && !"null".equals(author)) {
            context.operationBuilder().extensions(Lists.newArrayList(new StringVendorExtension("x-author", author)));
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

