/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.parser.SimpleValueParser;

public class MonthValueParser
extends SimpleValueParser {
    private static final String[] ALIASES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public MonthValueParser() {
        super(1, 12);
    }

    @Override
    public int parse(String value) throws CronException {
        try {
            return super.parse(value);
        }
        catch (Exception e) {
            return this.parseAlias(value);
        }
    }

    private int parseAlias(String value) throws CronException {
        for (int i2 = 0; i2 < ALIASES.length; ++i2) {
            if (!ALIASES[i2].equalsIgnoreCase(value)) continue;
            return i2 + 1;
        }
        throw new CronException("Invalid month alias: {}", value);
    }
}

