/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.reflect;

import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class ActualTypeMapperPool {
    private static final SimpleCache<Type, Map<Type, Type>> CACHE = new SimpleCache();

    public static Map<Type, Type> get(Type type) {
        return CACHE.get(type, () -> ActualTypeMapperPool.createTypeMap(type));
    }

    public static Type getActualType(Type type, TypeVariable<?> typeVariable) {
        Map<Type, Type> typeTypeMap = ActualTypeMapperPool.get(type);
        Type result = typeTypeMap.get(typeVariable);
        while (result instanceof TypeVariable) {
            result = typeTypeMap.get(result);
        }
        return result;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        Type[] result = new Type[typeVariables.length];
        for (int i2 = 0; i2 < typeVariables.length; ++i2) {
            result[i2] = typeVariables[i2] instanceof TypeVariable ? ActualTypeMapperPool.getActualType(type, (TypeVariable)typeVariables[i2]) : typeVariables[i2];
        }
        return result;
    }

    private static Map<Type, Type> createTypeMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (null != type && null != (parameterizedType = TypeUtil.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                typeMap.put(typeParameters[i2], typeArguments[i2]);
            }
            type = rawType;
        }
        return typeMap;
    }
}

