/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import java.util.Collection;
import java.util.Map;
import org.mapstruct.Mapper;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.SerializableParameterFactories;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper
public class ParameterMapper {
    private static final VendorExtensionsMapper vendorMapper = new VendorExtensionsMapper();

    public Parameter mapParameter(springfox.documentation.service.Parameter source) {
        Parameter bodyParameter = this.bodyParameter(source);
        return SerializableParameterFactories.create(source).or(bodyParameter);
    }

    private Parameter bodyParameter(springfox.documentation.service.Parameter source) {
        BodyParameter parameter = new BodyParameter().description(source.getDescription()).name(source.getName()).schema(this.fromModelRef(source.getModelRef()));
        parameter.setIn(source.getParamType());
        parameter.setAccess(source.getParamAccess());
        parameter.setPattern(source.getPattern());
        parameter.setRequired(source.isRequired());
        parameter.getVendorExtensions().putAll(vendorMapper.mapExtensions(source.getVendorExtentions()));
        for (Map.Entry<String, Collection<Example>> each : source.getExamples().asMap().entrySet()) {
            Optional example = FluentIterable.from(each.getValue()).first();
            if (!example.isPresent() || ((Example)example.get()).getValue() == null) continue;
            parameter.addExample(each.getKey(), String.valueOf(((Example)example.get()).getValue()));
        }
        return parameter;
    }

    Model fromModelRef(ModelReference modelRef) {
        if (modelRef.isCollection()) {
            if (modelRef.getItemType().equals("byte")) {
                ModelImpl baseModel = new ModelImpl();
                baseModel.setType("string");
                baseModel.setFormat("byte");
                return EnumMapper.maybeAddAllowableValuesToParameter(baseModel, modelRef.getAllowableValues());
            }
            if (modelRef.getItemType().equals("file")) {
                ArrayModel files = new ArrayModel();
                files.items(new FileProperty());
                return files;
            }
            ModelReference itemModel = modelRef.itemModel().get();
            return new ArrayModel().items(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(itemModel), itemModel.getAllowableValues()));
        }
        if (modelRef.isMap()) {
            ModelImpl baseModel = new ModelImpl();
            ModelReference itemModel = modelRef.itemModel().get();
            baseModel.additionalProperties(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty(itemModel), itemModel.getAllowableValues()));
            return baseModel;
        }
        if (Types.isBaseType(modelRef.getType())) {
            Property property = Properties.property(modelRef.getType());
            ModelImpl baseModel = new ModelImpl();
            baseModel.setType(property.getType());
            baseModel.setFormat(property.getFormat());
            return EnumMapper.maybeAddAllowableValuesToParameter(baseModel, modelRef.getAllowableValues());
        }
        return new RefModel(modelRef.getType());
    }
}

