/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import java.util.Map;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.swagger.web.SecurityConfiguration;

public class SecurityConfigurationBuilder {
    private String clientId;
    private String clientSecret;
    private String realm;
    private String appName;
    private String scopeSeparator;
    private Map<String, Object> additionalQueryStringParams;
    private Boolean useBasicAuthenticationWithAccessCodeGrant;

    private SecurityConfigurationBuilder() {
    }

    public static SecurityConfigurationBuilder builder() {
        return new SecurityConfigurationBuilder();
    }

    public SecurityConfiguration build() {
        return new SecurityConfiguration(BuilderDefaults.defaultIfAbsent(this.clientId, null), BuilderDefaults.defaultIfAbsent(this.clientSecret, null), BuilderDefaults.defaultIfAbsent(this.realm, null), BuilderDefaults.defaultIfAbsent(this.appName, null), BuilderDefaults.defaultIfAbsent(this.scopeSeparator, null), BuilderDefaults.defaultIfAbsent(this.additionalQueryStringParams, null), BuilderDefaults.defaultIfAbsent(this.useBasicAuthenticationWithAccessCodeGrant, null));
    }

    public SecurityConfigurationBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecurityConfigurationBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public SecurityConfigurationBuilder realm(String realm) {
        this.realm = realm;
        return this;
    }

    public SecurityConfigurationBuilder appName(String appName) {
        this.appName = appName;
        return this;
    }

    public SecurityConfigurationBuilder scopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
        return this;
    }

    public SecurityConfigurationBuilder additionalQueryStringParams(Map<String, Object> additionalQueryStringParams) {
        this.additionalQueryStringParams = additionalQueryStringParams;
        return this;
    }

    public SecurityConfigurationBuilder useBasicAuthenticationWithAccessCodeGrant(Boolean useBasicAuthenticationWithAccessCodeGrant) {
        this.useBasicAuthenticationWithAccessCodeGrant = useBasicAuthenticationWithAccessCodeGrant;
        return this;
    }
}

