/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.DefaultTagsProvider;

@Component
@Order(value=-2147482648)
public class SwaggerOperationTagsReader
implements OperationBuilderPlugin {
    private final DefaultTagsProvider tagsProvider;

    @Autowired
    public SwaggerOperationTagsReader(DefaultTagsProvider tagsProvider) {
        this.tagsProvider = tagsProvider;
    }

    @Override
    public void apply(OperationContext context) {
        ImmutableSet<String> defaultTags = this.tagsProvider.tags(context);
        Sets.SetView<String> tags = Sets.union(this.operationTags(context), this.controllerTags(context));
        if (tags.isEmpty()) {
            context.operationBuilder().tags(defaultTags);
        } else {
            context.operationBuilder().tags(tags);
        }
    }

    private Set<String> controllerTags(OperationContext context) {
        Optional<Api> controllerAnnotation = context.findControllerAnnotation(Api.class);
        return controllerAnnotation.transform(this.tagsFromController()).or(Sets.newHashSet());
    }

    private Set<String> operationTags(OperationContext context) {
        Optional<ApiOperation> annotation = context.findAnnotation(ApiOperation.class);
        return annotation.transform(this.tagsFromOperation()).or(Sets.newHashSet());
    }

    private Function<ApiOperation, Set<String>> tagsFromOperation() {
        return new Function<ApiOperation, Set<String>>(){

            @Override
            public Set<String> apply(ApiOperation input) {
                TreeSet<String> tags = Sets.newTreeSet();
                tags.addAll(FluentIterable.from(Lists.newArrayList(input.tags())).filter(Tags.emptyTags()).toSet());
                return tags;
            }
        };
    }

    private Function<Api, Set<String>> tagsFromController() {
        return new Function<Api, Set<String>>(){

            @Override
            public Set<String> apply(Api input) {
                TreeSet<String> tags = Sets.newTreeSet();
                tags.addAll(FluentIterable.from(Lists.newArrayList(input.tags())).filter(Tags.emptyTags()).toSet());
                return tags;
            }
        };
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

