/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ResponseHeader;
import java.util.HashMap;
import java.util.Map;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.service.Header;

public class ResponseHeaders {
    private ResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public static Function<ApiOperation, ResponseHeader[]> responseHeaders() {
        return new Function<ApiOperation, ResponseHeader[]>(){

            @Override
            public ResponseHeader[] apply(ApiOperation input) {
                return input.responseHeaders();
            }
        };
    }

    public static Map<String, Header> headers(ResponseHeader[] responseHeaders) {
        HashMap<String, Header> headers = Maps.newHashMap();
        for (ResponseHeader each : FluentIterable.from(Lists.newArrayList(responseHeaders)).filter(Predicates.not(ResponseHeaders.emptyOrVoid()))) {
            headers.put(each.name(), new Header(each.name(), each.description(), ResponseHeaders.headerModel(each)));
        }
        return headers;
    }

    private static Predicate<ResponseHeader> emptyOrVoid() {
        return new Predicate<ResponseHeader>(){

            @Override
            public boolean apply(ResponseHeader input) {
                return Strings.isNullOrEmpty(input.name()) || Void.class.equals(input.response());
            }
        };
    }

    private static ModelReference headerModel(ResponseHeader each) {
        String typeName = Optional.fromNullable(Types.typeNameFor(each.response())).or("string");
        ModelRef modelReference = Strings.isNullOrEmpty(each.responseContainer()) ? new ModelRef(typeName) : new ModelRef(each.responseContainer(), new ModelRef(typeName));
        return modelReference;
    }
}

