/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiImplicitParam;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component
@Order(value=-2147482648)
public class OperationImplicitParameterReader
implements OperationBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public OperationImplicitParameterReader(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public void apply(OperationContext context) {
        context.operationBuilder().parameters(this.readParameters(context));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    static Parameter implicitParameter(DescriptionResolver descriptions, ApiImplicitParam param) {
        ModelRef modelRef = OperationImplicitParameterReader.maybeGetModelRef(param);
        return new ParameterBuilder().name(param.name()).description(descriptions.resolve(param.value())).defaultValue(param.defaultValue()).required(param.required()).allowMultiple(param.allowMultiple()).modelRef(modelRef).allowableValues(ApiModelProperties.allowableValueFromString(param.allowableValues())).parameterType(Strings.emptyToNull(param.paramType())).parameterAccess(param.access()).order(-2147482648).scalarExample(param.example()).complexExamples(Examples.examples(param.examples())).build();
    }

    private static ModelRef maybeGetModelRef(ApiImplicitParam param) {
        String dataType = MoreObjects.firstNonNull(Strings.emptyToNull(param.dataType()), "string");
        AllowableValues allowableValues = null;
        if (Types.isBaseType(dataType)) {
            allowableValues = ApiModelProperties.allowableValueFromString(param.allowableValues());
        }
        if (param.allowMultiple()) {
            return new ModelRef("", new ModelRef(dataType, allowableValues));
        }
        return new ModelRef(dataType, allowableValues);
    }

    private List<Parameter> readParameters(OperationContext context) {
        Optional<ApiImplicitParam> annotation = context.findAnnotation(ApiImplicitParam.class);
        ArrayList<Parameter> parameters = Lists.newArrayList();
        if (annotation.isPresent()) {
            parameters.add(OperationImplicitParameterReader.implicitParameter(this.descriptions, annotation.get()));
        }
        return parameters;
    }
}

