/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.AuthorizationScopeBuilder;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class OperationAuthReader
implements OperationBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OperationAuthReader.class);

    @Override
    public void apply(OperationContext context) {
        List<SecurityContext> securityContexts = context.securityContext();
        HashMap<String, SecurityReference> securityReferences = Maps.newHashMap();
        for (SecurityContext each : securityContexts) {
            securityReferences.putAll(FluentIterable.from(each.securityForOperation(context)).uniqueIndex(this.byReferenceName()));
        }
        Optional<ApiOperation> apiOperationAnnotation = context.findAnnotation(ApiOperation.class);
        if (apiOperationAnnotation.isPresent()) {
            ArrayList<SecurityReference> securityReferenceOverrides = Lists.newArrayList();
            for (Authorization authorization : this.authorizationReferences(apiOperationAnnotation.get())) {
                String value = authorization.value();
                io.swagger.annotations.AuthorizationScope[] scopes = authorization.scopes();
                ArrayList<AuthorizationScope> authorizationScopeList = Lists.newArrayList();
                for (io.swagger.annotations.AuthorizationScope authorizationScope : scopes) {
                    String description = authorizationScope.description();
                    String scope = authorizationScope.scope();
                    if (Strings.isNullOrEmpty(scope)) continue;
                    authorizationScopeList.add(new AuthorizationScopeBuilder().scope(scope).description(description).build());
                }
                AuthorizationScope[] authorizationScopes = authorizationScopeList.toArray(new AuthorizationScope[0]);
                SecurityReference securityReference = SecurityReference.builder().reference(value).scopes(authorizationScopes).build();
                securityReferenceOverrides.add(securityReference);
            }
            securityReferences.putAll(FluentIterable.from(securityReferenceOverrides).uniqueIndex(this.byReferenceName()));
        }
        LOG.debug("Authorization count {} for method {}", (Object)securityReferences.size(), (Object)context.getName());
        context.operationBuilder().authorizations(securityReferences.values());
    }

    private Function<SecurityReference, String> byReferenceName() {
        return new Function<SecurityReference, String>(){

            @Override
            public String apply(SecurityReference input) {
                return input.getReference();
            }
        };
    }

    private Iterable<Authorization> authorizationReferences(ApiOperation apiOperationAnnotation) {
        return FluentIterable.from(apiOperationAnnotation.authorizations()).filter(new Predicate<Authorization>(){

            @Override
            public boolean apply(Authorization input) {
                return !Strings.isNullOrEmpty(input.value());
            }
        });
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

