/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Equivalence;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Operation;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.OperationCachingEquivalence;
import springfox.documentation.spring.web.readers.operation.OperationReader;

@Component
@Qualifier(value="cachedOperations")
public class CachingOperationReader
implements OperationReader {
    private final LoadingCache<Equivalence.Wrapper<RequestMappingContext>, List<Operation>> cache;

    @Autowired
    public CachingOperationReader(final @Qualifier(value="default") OperationReader delegate) {
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(24L, TimeUnit.HOURS).build(new CacheLoader<Equivalence.Wrapper<RequestMappingContext>, List<Operation>>(){

            @Override
            public List<Operation> load(Equivalence.Wrapper<RequestMappingContext> key) {
                return delegate.read(key.get());
            }
        });
    }

    @Override
    public List<Operation> read(RequestMappingContext outerContext) {
        return this.cache.getUnchecked(new OperationCachingEquivalence().wrap(outerContext));
    }
}

