/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.schema.Collections;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.readers.parameter.ParameterTypeDeterminer;

@Component
@Order(value=-2147483648)
public class ParameterTypeReader
implements ParameterBuilderPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterTypeReader.class);

    @Override
    public void apply(ParameterContext context) {
        context.parameterBuilder().parameterType(ParameterTypeReader.findParameterType(context));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public static String findParameterType(ParameterContext parameterContext) {
        ResolvedMethodParameter resolvedMethodParameter = parameterContext.resolvedMethodParameter();
        ResolvedType parameterType = resolvedMethodParameter.getParameterType();
        if (ParameterTypeReader.isFileType(parameterType = parameterContext.alternateFor(parameterType)) || ParameterTypeReader.isListOfFiles(parameterType)) {
            return "form";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(PathVariable.class)) {
            return "path";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestBody.class)) {
            return "body";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestPart.class)) {
            return "formData";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestParam.class)) {
            return ParameterTypeDeterminer.determineScalarParameterType(parameterContext.getOperationContext().consumes(), parameterContext.getOperationContext().httpMethod());
        }
        if (resolvedMethodParameter.hasParameterAnnotation(RequestHeader.class)) {
            return "header";
        }
        if (resolvedMethodParameter.hasParameterAnnotation(ModelAttribute.class)) {
            LOGGER.warn("@ModelAttribute annotated parameters should have already been expanded via the ExpandedParameterBuilderPlugin");
        }
        if (!resolvedMethodParameter.hasParameterAnnotations()) {
            return ParameterTypeDeterminer.determineScalarParameterType(parameterContext.getOperationContext().consumes(), parameterContext.getOperationContext().httpMethod());
        }
        return "body";
    }

    private static boolean isListOfFiles(ResolvedType parameterType) {
        return Collections.isContainerType(parameterType) && ParameterTypeReader.isFileType(Collections.collectionElementType(parameterType));
    }

    private static boolean isFileType(ResolvedType parameterType) {
        return MultipartFile.class.isAssignableFrom(parameterType.getErasedType());
    }
}

