/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483648)
public class ExpandedParameterBuilder
implements ExpandedParameterBuilderPlugin {
    private final TypeResolver resolver;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public ExpandedParameterBuilder(TypeResolver resolver, EnumTypeDeterminer enumTypeDeterminer) {
        this.resolver = resolver;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    @Override
    public void apply(ParameterExpansionContext context) {
        AllowableValues allowable = this.allowableValues(context.getFieldType().getErasedType());
        String name = Strings.isNullOrEmpty(context.getParentName()) ? context.getFieldName() : String.format("%s.%s", context.getParentName(), context.getFieldName());
        String typeName = context.getDataTypeName();
        ModelRef itemModel = null;
        ResolvedType resolved = this.resolver.resolve(context.getFieldType(), new Type[0]);
        if (Collections.isContainerType(resolved)) {
            resolved = this.fieldType(context).or(resolved);
            ResolvedType elementType = Collections.collectionElementType(resolved);
            String itemTypeName = Types.typeNameFor(elementType.getErasedType());
            AllowableValues itemAllowables = null;
            if (this.enumTypeDeterminer.isEnum(elementType.getErasedType())) {
                itemAllowables = Enums.allowableValues(elementType.getErasedType());
                itemTypeName = "string";
            }
            typeName = Collections.containerType(resolved);
            itemModel = new ModelRef(itemTypeName, itemAllowables);
        } else if (this.enumTypeDeterminer.isEnum(resolved.getErasedType())) {
            typeName = "string";
        }
        context.getParameterBuilder().name(name).description(null).defaultValue(null).required(Boolean.FALSE).allowMultiple(Collections.isContainerType(resolved)).type(resolved).modelRef(new ModelRef(typeName, itemModel)).allowableValues(allowable).parameterType(context.getParameterType()).order(0).parameterAccess(null);
    }

    private Optional<ResolvedType> fieldType(ParameterExpansionContext context) {
        return Optional.of(context.getFieldType());
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private AllowableValues allowableValues(Class<?> fieldType) {
        AllowableListValues allowable = null;
        if (this.enumTypeDeterminer.isEnum(fieldType)) {
            allowable = new AllowableListValues(this.getEnumValues(fieldType), "LIST");
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

