/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import springfox.documentation.OperationNameGenerator;

@Component
public class CachingOperationNameGenerator
implements OperationNameGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CachingOperationNameGenerator.class);
    private Map<String, Integer> generated = Maps.newHashMap();

    @Override
    public String startingWith(String prefix) {
        if (this.generated.containsKey(prefix)) {
            this.generated.put(prefix, this.generated.get(prefix) + 1);
            String nextUniqueOperationName = String.format("%s_%s", prefix, this.generated.get(prefix));
            LOG.info("Generating unique operation named: {}", (Object)nextUniqueOperationName);
            return nextUniqueOperationName;
        }
        this.generated.put(prefix, 0);
        return prefix;
    }
}

