/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.Parameters;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;

public abstract class AbstractOperationParameterRequestConditionReader
implements OperationBuilderPlugin {
    private final TypeResolver resolver;

    public AbstractOperationParameterRequestConditionReader(TypeResolver resolver) {
        this.resolver = resolver;
    }

    public List<Parameter> getParameters(Set<NameValueExpression<String>> expressions, String parameterType) {
        ArrayList<Parameter> parameters = Lists.newArrayList();
        for (NameValueExpression<String> expression : expressions) {
            if (this.skipParameter(parameters, expression)) continue;
            String paramValue = expression.getValue();
            AllowableListValues allowableValues = null;
            if (!Strings.isNullOrEmpty(paramValue)) {
                allowableValues = new AllowableListValues(Lists.newArrayList(paramValue), "string");
            }
            Parameter parameter = new ParameterBuilder().name(expression.getName()).description(null).defaultValue(paramValue).required(true).allowMultiple(false).type(this.resolver.resolve((Type)((Object)String.class), new Type[0])).modelRef(new ModelRef("string")).allowableValues(allowableValues).parameterType(parameterType).order(0).build();
            parameters.add(parameter);
        }
        return parameters;
    }

    private boolean skipParameter(List<Parameter> parameters, NameValueExpression<String> expression) {
        return expression.isNegated() || this.parameterHandled(parameters, expression);
    }

    private boolean parameterHandled(List<Parameter> parameters, NameValueExpression<String> expression) {
        return Iterables.any(parameters, Parameters.withName(expression.getName()));
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

