/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.schema.AlternateTypeRules;

public class JacksonSerializerConvention
implements AlternateTypeRuleConvention {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonSerializerConvention.class);
    private static final int IMMUTABLES_CONVENTION_ORDER = -2147479648;
    private final TypeResolver resolver;
    private final String packagePrefix;

    public JacksonSerializerConvention(TypeResolver resolver, String packagePrefix) {
        this.resolver = resolver;
        this.packagePrefix = packagePrefix;
    }

    @Override
    public List<AlternateTypeRule> rules() {
        ArrayList<AlternateTypeRule> rules = Lists.newArrayList();
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        Set serialized = reflections.getTypesAnnotatedWith(JsonSerialize.class);
        Set deserialized = reflections.getTypesAnnotatedWith(JsonDeserialize.class);
        for (Class type : Sets.union(serialized, deserialized)) {
            Optional<Type> found = this.findAlternate(type);
            if (!found.isPresent()) continue;
            rules.add(AlternateTypeRules.newRule(this.resolver.resolve(type, new Type[0]), this.resolver.resolve(found.get(), new Type[0]), this.getOrder()));
            rules.add(AlternateTypeRules.newRule(this.resolver.resolve((Type)((Object)ResponseEntity.class), type), this.resolver.resolve(found.get(), new Type[0]), this.getOrder()));
        }
        return rules;
    }

    private Optional<Type> findAlternate(Class<?> type) {
        Class<Void> deserializer;
        Class<Void> serializer = Optional.fromNullable(type.getAnnotation(JsonSerialize.class)).transform(new Function<JsonSerialize, Class>(){

            @Override
            public Class apply(JsonSerialize input) {
                return input.as();
            }
        }).or(Void.class);
        if (serializer != (deserializer = Optional.fromNullable(type.getAnnotation(JsonDeserialize.class)).transform(new Function<JsonDeserialize, Class>(){

            @Override
            public Class apply(JsonDeserialize input) {
                return input.as();
            }
        }).or(Void.class))) {
            LOGGER.warn("The serializer {} and deserializer {} . Picking the serializer by default", (Object)serializer.getName(), (Object)deserializer.getName());
        }
        Class<Void> toUse = serializer == Void.class && deserializer == Void.class ? null : (serializer != Void.class ? serializer : deserializer);
        return Optional.fromNullable(toUse);
    }

    @Override
    public int getOrder() {
        return -2147479648;
    }
}

