/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRuleConvention;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.RequestHandlerCombiner;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Defaults;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.DocumentationContextBuilder;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.plugins.DefaultConfiguration;
import springfox.documentation.spring.web.plugins.DefaultRequestHandlerCombiner;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDocumentationScanner;

@Component
public class DocumentationPluginsBootstrapper
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DocumentationPluginsBootstrapper.class);
    private static final String SPRINGFOX_DOCUMENTATION_AUTO_STARTUP = "springfox.documentation.auto-startup";
    private final DocumentationPluginsManager documentationPluginsManager;
    private final List<RequestHandlerProvider> handlerProviders;
    private final DocumentationCache scanned;
    private final ApiDocumentationScanner resourceListing;
    private final Environment environment;
    private final DefaultConfiguration defaultConfiguration;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    @Autowired(required=false)
    private RequestHandlerCombiner combiner;
    @Autowired(required=false)
    private List<AlternateTypeRuleConvention> typeConventions;

    @Autowired
    public DocumentationPluginsBootstrapper(DocumentationPluginsManager documentationPluginsManager, List<RequestHandlerProvider> handlerProviders, DocumentationCache scanned, ApiDocumentationScanner resourceListing, TypeResolver typeResolver, Defaults defaults, ServletContext servletContext, Environment environment2) {
        this.documentationPluginsManager = documentationPluginsManager;
        this.handlerProviders = handlerProviders;
        this.scanned = scanned;
        this.resourceListing = resourceListing;
        this.environment = environment2;
        this.defaultConfiguration = new DefaultConfiguration(defaults, typeResolver, servletContext);
    }

    private DocumentationContext buildContext(DocumentationPlugin each) {
        return each.configure(this.defaultContextBuilder(each));
    }

    private void scanDocumentation(DocumentationContext context) {
        try {
            this.scanned.addDocumentation(this.resourceListing.scan(context));
        }
        catch (Exception e) {
            log.error(String.format("Unable to scan documentation context %s", context.getGroupName()), e);
        }
    }

    private DocumentationContextBuilder defaultContextBuilder(DocumentationPlugin plugin) {
        DocumentationType documentationType = plugin.getDocumentationType();
        ImmutableList<RequestHandler> requestHandlers = FluentIterable.from(this.handlerProviders).transformAndConcat(this.handlers()).toList();
        ImmutableList<AlternateTypeRule> rules = FluentIterable.from(BuilderDefaults.nullToEmptyList(this.typeConventions)).transformAndConcat(this.toRules()).toList();
        return this.documentationPluginsManager.createContextBuilder(documentationType, this.defaultConfiguration).rules(rules).requestHandlers(this.combiner().combine(requestHandlers));
    }

    private Function<AlternateTypeRuleConvention, List<AlternateTypeRule>> toRules() {
        return new Function<AlternateTypeRuleConvention, List<AlternateTypeRule>>(){

            @Override
            public List<AlternateTypeRule> apply(AlternateTypeRuleConvention input) {
                return input.rules();
            }
        };
    }

    private RequestHandlerCombiner combiner() {
        return Optional.fromNullable(this.combiner).or(new DefaultRequestHandlerCombiner());
    }

    private Function<RequestHandlerProvider, ? extends Iterable<RequestHandler>> handlers() {
        return new Function<RequestHandlerProvider, Iterable<RequestHandler>>(){

            @Override
            public Iterable<RequestHandler> apply(RequestHandlerProvider input) {
                return input.requestHandlers();
            }
        };
    }

    @Override
    public boolean isAutoStartup() {
        String autoStartupConfig = this.environment.getProperty(SPRINGFOX_DOCUMENTATION_AUTO_STARTUP, "true");
        return Boolean.valueOf(autoStartupConfig);
    }

    @Override
    public void stop(Runnable callback) {
        callback.run();
    }

    @Override
    public void start() {
        if (this.initialized.compareAndSet(false, true)) {
            log.info("Context refreshed");
            List<DocumentationPlugin> plugins = Orderings.pluginOrdering().sortedCopy(this.documentationPluginsManager.documentationPlugins());
            log.info("Found {} custom documentation plugin(s)", (Object)plugins.size());
            for (DocumentationPlugin each : plugins) {
                DocumentationType documentationType = each.getDocumentationType();
                if (each.isEnabled()) {
                    this.scanDocumentation(this.buildContext(each));
                    continue;
                }
                log.info("Skipping initializing disabled plugin bean {} v{}", (Object)documentationType.getName(), (Object)documentationType.getVersion());
            }
        }
    }

    @Override
    public void stop() {
        this.initialized.getAndSet(false);
        this.scanned.clear();
    }

    @Override
    public boolean isRunning() {
        return this.initialized.get();
    }

    @Override
    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

