/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerCombiner;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.plugins.CombinedRequestHandler;
import springfox.documentation.spring.web.plugins.PathAndParametersEquivalence;

class DefaultRequestHandlerCombiner
implements RequestHandlerCombiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestHandlerCombiner.class);
    private static final PathAndParametersEquivalence EQUIVALENCE = new PathAndParametersEquivalence();

    DefaultRequestHandlerCombiner() {
    }

    @Override
    public List<RequestHandler> combine(List<RequestHandler> source) {
        ArrayList<? extends RequestHandler> combined = new ArrayList<RequestHandler>();
        LinkedListMultimap<String, RequestHandler> byPath = LinkedListMultimap.create();
        LOGGER.debug("Total number of request handlers {}", (Object)BuilderDefaults.nullToEmptyList(source).size());
        for (RequestHandler each : BuilderDefaults.nullToEmptyList(source)) {
            LOGGER.debug("Adding key: {}, {}", (Object)Orderings.patternsCondition(each).toString(), (Object)each.toString());
            byPath.put(Orderings.patternsCondition(each).toString(), each);
        }
        for (String key : byPath.keySet()) {
            combined.addAll(this.combined(byPath.get(key)));
        }
        LOGGER.debug("Combined number of request handlers {}", (Object)combined.size());
        return Orderings.byPatternsCondition().sortedCopy(combined);
    }

    private Collection<? extends RequestHandler> combined(Collection<RequestHandler> requestHandlers) {
        ArrayList<RequestHandler> source = Lists.newArrayList(requestHandlers);
        if (source.size() == 0 || source.size() == 1) {
            return requestHandlers;
        }
        ImmutableListMultimap<Equivalence.Wrapper<RequestHandler>, RequestHandler> groupByEquality = this.safeGroupBy(source);
        ArrayList<RequestHandler> combined = Lists.newArrayList();
        for (Equivalence.Wrapper path : this.wrapperComparator().sortedCopy(groupByEquality.keySet())) {
            List<RequestHandler> handlers = groupByEquality.get(path);
            RequestHandler toCombine = (RequestHandler)path.get();
            if (handlers.size() > 1) {
                for (RequestHandler each : this.sortedByPathAndName(handlers)) {
                    if (each.equals(toCombine)) continue;
                    LOGGER.debug("Combining {} and {}", (Object)toCombine.toString(), (Object)each.toString());
                    toCombine = this.combine(toCombine, each);
                }
            }
            combined.add(toCombine);
        }
        return combined;
    }

    private List<RequestHandler> sortedByPathAndName(List<RequestHandler> handlers) {
        return Orderings.byPatternsCondition().compound(Orderings.byOperationName()).sortedCopy(handlers);
    }

    private Ordering<Equivalence.Wrapper<RequestHandler>> wrapperComparator() {
        return Ordering.from(new Comparator<Equivalence.Wrapper<RequestHandler>>(){

            @Override
            public int compare(Equivalence.Wrapper<RequestHandler> first, Equivalence.Wrapper<RequestHandler> second) {
                return Orderings.byPatternsCondition().compound(Orderings.byOperationName()).compare(first.get(), second.get());
            }
        });
    }

    private ImmutableListMultimap<Equivalence.Wrapper<RequestHandler>, RequestHandler> safeGroupBy(List<RequestHandler> source) {
        try {
            return Multimaps.index(source, this.equivalenceAsKey());
        }
        catch (Exception e) {
            LOGGER.error("Unable to index request handlers {}. Request handlers with issues{}", (Object)e.getMessage(), (Object)this.keys(source));
            return ImmutableListMultimap.builder().build();
        }
    }

    private String keys(List<RequestHandler> source) {
        StringBuffer sb = new StringBuffer("Request Handlers with duplicate keys {");
        for (int i2 = 0; i2 < source.size(); ++i2) {
            sb.append('\t').append(i2).append(". ").append(source.get(i2).key());
        }
        sb.append('}');
        return sb.toString();
    }

    private Function<RequestHandler, Equivalence.Wrapper<RequestHandler>> equivalenceAsKey() {
        return new Function<RequestHandler, Equivalence.Wrapper<RequestHandler>>(){

            @Override
            public Equivalence.Wrapper<RequestHandler> apply(RequestHandler input) {
                return EQUIVALENCE.wrap(input);
            }
        };
    }

    private RequestHandler combine(RequestHandler first, RequestHandler second) {
        return new CombinedRequestHandler(first, second);
    }
}

