/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Order(value=-2147483648)
public class PropertyDiscriminatorBasedInheritancePlugin
implements ModelBuilderPlugin {
    private final TypeResolver typeResolver;
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public PropertyDiscriminatorBasedInheritancePlugin(TypeResolver typeResolver, TypeNameExtractor typeNameExtractor) {
        this.typeResolver = typeResolver;
        this.typeNameExtractor = typeNameExtractor;
    }

    @Override
    public void apply(ModelContext context) {
        List<ModelReference> modelRefs = this.modelRefs(context);
        if (!modelRefs.isEmpty()) {
            context.getBuilder().discriminator(this.discriminator(context)).subTypes(modelRefs);
        }
    }

    private List<ModelReference> modelRefs(ModelContext context) {
        JsonSubTypes subTypes = AnnotationUtils.getAnnotation(this.forClass(context), JsonSubTypes.class);
        ArrayList<ModelReference> modelRefs = new ArrayList<ModelReference>();
        if (subTypes != null) {
            for (JsonSubTypes.Type each : subTypes.value()) {
                modelRefs.add(ResolvedTypes.modelRefFactory(context, this.typeNameExtractor).apply(this.typeResolver.resolve(each.value(), new Type[0])));
            }
        }
        return modelRefs;
    }

    private String discriminator(ModelContext context) {
        JsonTypeInfo typeInfo = AnnotationUtils.getAnnotation(this.forClass(context), JsonTypeInfo.class);
        if (typeInfo != null && typeInfo.use() == JsonTypeInfo.Id.NAME && typeInfo.include() == JsonTypeInfo.As.PROPERTY) {
            return Optional.fromNullable(Strings.emptyToNull(typeInfo.property())).or(typeInfo.use().getDefaultPropertyName());
        }
        return "";
    }

    private Class<?> forClass(ModelContext context) {
        return this.typeResolver.resolve(context.getType(), new Type[0]).getErasedType();
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

