/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.types.ResolvedArrayType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.List;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ModelReferenceProvider;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.schema.contexts.ModelContext;

public class ResolvedTypes {
    private ResolvedTypes() {
        throw new UnsupportedOperationException();
    }

    public static String simpleQualifiedTypeName(ResolvedType type) {
        if (type instanceof ResolvedPrimitiveType) {
            Class<?> primitiveType = type.getErasedType();
            return Types.typeNameFor(primitiveType);
        }
        if (type instanceof ResolvedArrayType) {
            return Types.typeNameFor(type.getArrayElementType().getErasedType());
        }
        return type.getErasedType().getName();
    }

    public static AllowableValues allowableValues(ResolvedType resolvedType) {
        List<ResolvedType> typeParameters;
        if (Collections.isContainerType(resolvedType) && (typeParameters = resolvedType.getTypeParameters()) != null && typeParameters.size() == 1) {
            return Enums.allowableValues(typeParameters.get(0).getErasedType());
        }
        return Enums.allowableValues(resolvedType.getErasedType());
    }

    public static Optional<String> resolvedTypeSignature(ResolvedType resolvedType) {
        return Optional.fromNullable(resolvedType).transform(new Function<ResolvedType, String>(){

            @Override
            public String apply(ResolvedType input) {
                return input.getSignature();
            }
        });
    }

    public static Function<ResolvedType, ModelReference> modelRefFactory(ModelContext parentContext, TypeNameExtractor typeNameExtractor) {
        return new ModelReferenceProvider(typeNameExtractor, parentContext);
    }
}

