/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.Parameters;
import springfox.documentation.service.Parameter;

class ParameterMerger {
    private final List<Parameter> destination;
    private final List<Parameter> source;

    public ParameterMerger(List<Parameter> destination, List<Parameter> source) {
        this.destination = Lists.newArrayList(destination);
        this.source = Lists.newArrayList(source);
    }

    public List<Parameter> merged() {
        ImmutableSet<String> existingParameterNames = FluentIterable.from(this.destination).transform(Parameters.toParameterName()).toSet();
        ImmutableSet<String> newParameterNames = FluentIterable.from(this.source).transform(Parameters.toParameterName()).toSet();
        ArrayList<Parameter> merged = Lists.newArrayList();
        Sets.SetView<String> asIsParams = Sets.difference(existingParameterNames, newParameterNames);
        Sets.SetView<String> missingParamNames = Sets.difference(newParameterNames, existingParameterNames);
        Sets.SetView<String> paramsToMerge = Sets.intersection(newParameterNames, existingParameterNames);
        merged.addAll(this.asIsParameters(asIsParams, this.destination));
        merged.addAll(this.newParameters(missingParamNames, this.source));
        merged.addAll(this.mergedParameters(paramsToMerge, this.destination, this.source));
        return merged;
    }

    private List<Parameter> asIsParameters(Sets.SetView<String> asIsParams, List<Parameter> source) {
        ArrayList<Parameter> parameters = Lists.newArrayList();
        for (Parameter each : source) {
            if (!asIsParams.contains(each.getName())) continue;
            parameters.add(each);
        }
        return parameters;
    }

    private List<Parameter> mergedParameters(Sets.SetView<String> paramsToMerge, List<Parameter> existingParameters, List<Parameter> newParams) {
        ArrayList<Parameter> parameters = Lists.newArrayList();
        for (Parameter newParam : newParams) {
            Optional<Parameter> original = FluentIterable.from(existingParameters).firstMatch(Parameters.withName(newParam.getName()));
            if (!paramsToMerge.contains(newParam.getName()) || !original.isPresent()) continue;
            if (newParam.getOrder() > original.get().getOrder()) {
                parameters.add(this.merged(newParam, original.get()));
                continue;
            }
            parameters.add(this.merged(original.get(), newParam));
        }
        return parameters;
    }

    private Parameter merged(Parameter destination, Parameter source) {
        return new ParameterBuilder().from(destination).name(source.getName()).allowableValues(source.getAllowableValues()).allowMultiple(source.isAllowMultiple()).defaultValue(source.getDefaultValue()).description(source.getDescription()).modelRef(source.getModelRef()).parameterAccess(source.getParamAccess()).parameterType(source.getParamType()).required(source.isRequired()).type(source.getType().orNull()).order(source.getOrder()).scalarExample(source.getScalarExample()).complexExamples(source.getExamples()).build();
    }

    private List<Parameter> newParameters(Sets.SetView<String> missingParamNames, List<Parameter> newParams) {
        ArrayList<Parameter> parameters = Lists.newArrayList();
        for (Parameter each : newParams) {
            if (!missingParamNames.contains(each.getName())) continue;
            parameters.add(each);
        }
        return parameters;
    }
}

