/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorClientHttpRequest;
import org.springframework.http.client.reactive.ReactorClientHttpResponse;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

public class ReactorClientHttpConnector
implements ClientHttpConnector {
    private static final Function<HttpClient, HttpClient> defaultInitializer = client -> client.compress(true);
    private final HttpClient httpClient;

    public ReactorClientHttpConnector() {
        this.httpClient = defaultInitializer.apply(HttpClient.create());
    }

    public ReactorClientHttpConnector(ReactorResourceFactory factory, Function<HttpClient, HttpClient> mapper) {
        this.httpClient = defaultInitializer.andThen(mapper).apply(ReactorClientHttpConnector.initHttpClient(factory));
    }

    private static HttpClient initHttpClient(ReactorResourceFactory resourceFactory) {
        ConnectionProvider provider = resourceFactory.getConnectionProvider();
        LoopResources resources2 = resourceFactory.getLoopResources();
        Assert.notNull((Object)provider, "No ConnectionProvider: is ReactorResourceFactory not initialized yet?");
        Assert.notNull((Object)resources2, "No LoopResources: is ReactorResourceFactory not initialized yet?");
        return HttpClient.create((ConnectionProvider)provider).tcpConfiguration(tcpClient -> tcpClient.runOn(resources2));
    }

    public ReactorClientHttpConnector(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        this.httpClient = httpClient;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + uri));
        }
        return ((HttpClient.RequestSender)this.httpClient.request(io.netty.handler.codec.http.HttpMethod.valueOf((String)method.name())).uri(uri.toString())).send((request, outbound) -> (Mono)requestCallback.apply(this.adaptRequest(method, uri, (HttpClientRequest)request, (NettyOutbound)outbound))).responseConnection((res, con) -> Mono.just((Object)this.adaptResponse((HttpClientResponse)res, con.inbound(), con.outbound().alloc()))).next();
    }

    private ReactorClientHttpRequest adaptRequest(HttpMethod method, URI uri, HttpClientRequest request, NettyOutbound nettyOutbound) {
        return new ReactorClientHttpRequest(method, uri, request, nettyOutbound);
    }

    private ClientHttpResponse adaptResponse(HttpClientResponse response, NettyInbound nettyInbound, ByteBufAllocator allocator) {
        return new ReactorClientHttpResponse(response, nettyInbound, allocator);
    }
}

