/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.neo4j;

import java.util.List;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jBookmarkManagementConfiguration;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.web.support.OpenSessionInViewInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SessionFactory.class, Neo4jTransactionManager.class, PlatformTransactionManager.class})
@EnableConfigurationProperties(value={Neo4jProperties.class})
@Import(value={Neo4jBookmarkManagementConfiguration.class})
public class Neo4jDataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public Neo4jTransactionManager transactionManager(SessionFactory sessionFactory, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        Neo4jTransactionManager transactionManager = new Neo4jTransactionManager(sessionFactory);
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
        return transactionManager;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={WebMvcConfigurer.class, OpenSessionInViewInterceptor.class})
    @ConditionalOnMissingBean(value={OpenSessionInViewInterceptor.class})
    @ConditionalOnProperty(prefix="spring.data.neo4j", name={"open-in-view"}, havingValue="true")
    static class Neo4jWebConfiguration {
        Neo4jWebConfiguration() {
        }

        @Bean
        OpenSessionInViewInterceptor neo4jOpenSessionInViewInterceptor() {
            return new OpenSessionInViewInterceptor();
        }

        @Bean
        WebMvcConfigurer neo4jOpenSessionInViewInterceptorConfigurer(final OpenSessionInViewInterceptor interceptor) {
            return new WebMvcConfigurer(){

                @Override
                public void addInterceptors(InterceptorRegistry registry) {
                    registry.addWebRequestInterceptor((WebRequestInterceptor)interceptor);
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={SessionFactory.class})
    static class Neo4jOgmSessionFactoryConfiguration {
        Neo4jOgmSessionFactoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        org.neo4j.ogm.config.Configuration configuration(Neo4jProperties properties) {
            return properties.createConfiguration();
        }

        @Bean
        SessionFactory sessionFactory(org.neo4j.ogm.config.Configuration configuration, BeanFactory beanFactory, ObjectProvider<EventListener> eventListeners) {
            SessionFactory sessionFactory = new SessionFactory(configuration, this.getPackagesToScan(beanFactory));
            eventListeners.orderedStream().forEach(arg_0 -> ((SessionFactory)sessionFactory).register(arg_0));
            return sessionFactory;
        }

        private String[] getPackagesToScan(BeanFactory beanFactory) {
            List<String> packages = EntityScanPackages.get(beanFactory).getPackageNames();
            if (packages.isEmpty() && AutoConfigurationPackages.has(beanFactory)) {
                packages = AutoConfigurationPackages.get(beanFactory);
            }
            return StringUtils.toStringArray(packages);
        }
    }
}

