/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.BootstrapConfiguration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.ResourceLoaderHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidationBootstrapParameters {
    private static final Log log = LoggerFactory.make();
    private ConstraintValidatorFactory constraintValidatorFactory;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ParameterNameProvider parameterNameProvider;
    private ValidationProvider<?> provider;
    private Class<? extends ValidationProvider<?>> providerClass = null;
    private final Map<String, String> configProperties = new HashMap<String, String>();
    private final Set<InputStream> mappings = new HashSet<InputStream>();

    public ValidationBootstrapParameters() {
    }

    public ValidationBootstrapParameters(BootstrapConfiguration bootstrapConfiguration) {
        this.setProviderClass(bootstrapConfiguration.getDefaultProviderClassName());
        this.setMessageInterpolator(bootstrapConfiguration.getMessageInterpolatorClassName());
        this.setTraversableResolver(bootstrapConfiguration.getTraversableResolverClassName());
        this.setConstraintFactory(bootstrapConfiguration.getConstraintValidatorFactoryClassName());
        this.setParameterNameProvider(bootstrapConfiguration.getParameterNameProviderClassName());
        this.setMappingStreams(bootstrapConfiguration.getConstraintMappingResourcePaths());
        this.setConfigProperties(bootstrapConfiguration.getProperties());
    }

    public final ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public final void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public final MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public final void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public final ValidationProvider<?> getProvider() {
        return this.provider;
    }

    public final void setProvider(ValidationProvider<?> provider) {
        this.provider = provider;
    }

    public final Class<? extends ValidationProvider<?>> getProviderClass() {
        return this.providerClass;
    }

    public final void setProviderClass(Class<? extends ValidationProvider<?>> providerClass) {
        this.providerClass = providerClass;
    }

    public final TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public final void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public final void addConfigProperty(String key, String value) {
        this.configProperties.put(key, value);
    }

    public final void addMapping(InputStream in) {
        this.mappings.add(in);
    }

    public final void addAllMappings(Set<InputStream> mappings) {
        this.mappings.addAll(mappings);
    }

    public final Set<InputStream> getMappings() {
        return Collections.unmodifiableSet(this.mappings);
    }

    public final Map<String, String> getConfigProperties() {
        return Collections.unmodifiableMap(this.configProperties);
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider;
    }

    public void setParameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.parameterNameProvider = parameterNameProvider;
    }

    private void setProviderClass(String providerFqcn) {
        if (providerFqcn != null) {
            try {
                this.providerClass = ReflectionHelper.loadClass((String)providerFqcn, this.getClass());
                log.usingValidationProvider(providerFqcn);
            }
            catch (Exception e) {
                throw log.getUnableToInstantiateValidationProviderClassException(providerFqcn, e);
            }
        }
    }

    private void setMessageInterpolator(String messageInterpolatorFqcn) {
        if (messageInterpolatorFqcn != null) {
            try {
                Class messageInterpolatorClass = ReflectionHelper.loadClass((String)messageInterpolatorFqcn, this.getClass());
                this.messageInterpolator = (MessageInterpolator)ReflectionHelper.newInstance((Class)messageInterpolatorClass, (String)"message interpolator");
                log.usingMessageInterpolator(messageInterpolatorFqcn);
            }
            catch (ValidationException e) {
                throw log.getUnableToInstantiateMessageInterpolatorClassException(messageInterpolatorFqcn, e);
            }
        }
    }

    private void setTraversableResolver(String traversableResolverFqcn) {
        if (traversableResolverFqcn != null) {
            try {
                Class clazz = ReflectionHelper.loadClass((String)traversableResolverFqcn, this.getClass());
                this.traversableResolver = (TraversableResolver)ReflectionHelper.newInstance((Class)clazz, (String)"traversable resolver");
                log.usingTraversableResolver(traversableResolverFqcn);
            }
            catch (ValidationException e) {
                throw log.getUnableToInstantiateTraversableResolverClassException(traversableResolverFqcn, e);
            }
        }
    }

    private void setConstraintFactory(String constraintFactoryFqcn) {
        if (constraintFactoryFqcn != null) {
            try {
                Class clazz = ReflectionHelper.loadClass((String)constraintFactoryFqcn, this.getClass());
                this.constraintValidatorFactory = (ConstraintValidatorFactory)ReflectionHelper.newInstance((Class)clazz, (String)"constraint factory class");
                log.usingConstraintFactory(constraintFactoryFqcn);
            }
            catch (ValidationException e) {
                throw log.getUnableToInstantiateConstraintFactoryClassException(constraintFactoryFqcn, e);
            }
        }
    }

    private void setParameterNameProvider(String parameterNameProviderFqcn) {
        if (parameterNameProviderFqcn != null) {
            try {
                Class clazz = ReflectionHelper.loadClass((String)parameterNameProviderFqcn, this.getClass());
                this.parameterNameProvider = (ParameterNameProvider)ReflectionHelper.newInstance((Class)clazz, (String)"parameter name provider class");
                log.usingParameterNameProvider(parameterNameProviderFqcn);
            }
            catch (ValidationException e) {
                throw log.getUnableToInstantiateParameterNameProviderClassException(parameterNameProviderFqcn, e);
            }
        }
    }

    private void setMappingStreams(Set<String> mappingFileNames) {
        for (String mappingFileName : mappingFileNames) {
            log.debugf("Trying to open input stream for %s.", (Object)mappingFileName);
            InputStream in = ResourceLoaderHelper.getResettableInputStreamForPath(mappingFileName);
            if (in == null) {
                throw log.getUnableToOpenInputStreamForMappingFileException(mappingFileName);
            }
            this.mappings.add(in);
        }
    }

    private void setConfigProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.configProperties.put(entry.getKey(), entry.getValue());
        }
    }
}

