/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.xml.GroupConversionType;

public class GroupConversionBuilder {
    private GroupConversionBuilder() {
    }

    public static Map<Class<?>, Class<?>> buildGroupConversionMap(List<GroupConversionType> groupConversionTypes, String defaultPackage) {
        HashMap<Class<?>, Class<?>> groupConversionMap = CollectionHelper.newHashMap();
        for (GroupConversionType groupConversionType : groupConversionTypes) {
            Class fromClass = ReflectionHelper.loadClass((String)groupConversionType.getFrom(), (String)defaultPackage);
            Class toClass = ReflectionHelper.loadClass((String)groupConversionType.getTo(), (String)defaultPackage);
            groupConversionMap.put(fromClass, toClass);
        }
        return groupConversionMap;
    }
}

