/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicResponseParameters;
import com.github.xiaoymin.knife4j.spring.util.ByteUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.ResponseMessagesReader;

@Component
@Order(value=-2147482598)
public class DynamicResponseModelReader
implements OperationBuilderPlugin {
    private final TypeNameExtractor typeNameExtractor;
    private final Map<String, String> cacheGenModelMaps = new HashMap<String, String>();
    @Autowired
    private TypeResolver typeResolver;

    @Autowired
    public DynamicResponseModelReader(TypeNameExtractor typeNameExtractor) {
        this.typeNameExtractor = typeNameExtractor;
    }

    @Override
    public void apply(OperationContext context) {
        Optional<ApiOperationSupport> optional = context.findAnnotation(ApiOperationSupport.class);
        if (optional.isPresent()) {
            this.changeResponseModel(optional.get().responses(), context);
        } else {
            Optional<DynamicResponseParameters> parametersOptional = context.findAnnotation(DynamicResponseParameters.class);
            if (parametersOptional.isPresent()) {
                this.changeResponseModel(parametersOptional.get(), context);
            }
        }
    }

    private void changeResponseModel(DynamicResponseParameters dynamicResponseParameters, OperationContext operationContext) {
        if (dynamicResponseParameters != null) {
            DynamicParameter[] parameters = dynamicResponseParameters.properties();
            int fieldCount = 0;
            for (DynamicParameter dynamicParameter : parameters) {
                if (dynamicParameter.name() == null || "".equals(dynamicParameter.name()) || "null".equals(dynamicParameter.name())) continue;
                ++fieldCount;
            }
            if (fieldCount > 0) {
                String name = dynamicResponseParameters.name();
                if (name == null || "".equals(name)) {
                    name = this.genClassName(operationContext);
                }
                if (this.cacheGenModelMaps.containsKey(name)) {
                    name = this.genClassName(operationContext);
                }
                name = operationContext.getGroupName().replaceAll("[_-]", "") + "." + name + "Response";
                String classPath = "com.github.xiaoymin.knife4j.model." + name;
                Class<?> loadClass = ByteUtils.load(classPath);
                if (loadClass != null) {
                    ResolvedType returnType = operationContext.alternateFor(this.typeResolver.resolve(loadClass, new Type[0]));
                    int httpStatusCode = ResponseMessagesReader.httpStatusCode(operationContext);
                    String message = ResponseMessagesReader.message(operationContext);
                    ModelReference modelRef = null;
                    if (!Types.isVoid(returnType)) {
                        ModelContext modelContext = ModelContext.returnValue(operationContext.getGroupName(), returnType, operationContext.getDocumentationType(), operationContext.getAlternateTypeProvider(), operationContext.getGenericsNamingStrategy(), operationContext.getIgnorableParameterTypes());
                        modelRef = ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor).apply(returnType);
                    }
                    ResponseMessage built = new ResponseMessageBuilder().code(httpStatusCode).message(message).responseModel(modelRef).build();
                    operationContext.operationBuilder().responseMessages(Sets.newHashSet(built));
                }
            }
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public String genClassName(OperationContext context) {
        String name = context.getName();
        if (name != null && !"".equals(name)) {
            name = (name = name.replaceAll("[_-]", "")).length() == 1 ? name.toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }
}

