/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.github.xiaoymin.knife4j.spring.extension.ApiAuthorExtension;
import com.github.xiaoymin.knife4j.spring.extension.ApiOrderExtension;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import springfox.documentation.service.Tag;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

public class ApiSupportListingReaderPlugin
implements ApiListingBuilderPlugin {
    @Override
    public void apply(ApiListingContext apiListingContext) {
        Optional<Class<?>> controller = apiListingContext.getResourceGroup().getControllerClass();
        if (controller.isPresent()) {
            ApiSupport apiSupport;
            String author;
            Optional<Api> apiAnnotation = Optional.fromNullable(AnnotationUtils.findAnnotation(controller.get(), Api.class));
            String description = Strings.emptyToNull(apiAnnotation.transform(this.descriptionExtractor()).orNull());
            Set tagSet = apiAnnotation.transform(this.tags()).or(Sets.newTreeSet());
            if (tagSet.isEmpty()) {
                tagSet.add(apiListingContext.getResourceGroup().getGroupName());
            }
            Optional<ApiSupport> apiSupportAnnotation = Optional.fromNullable(AnnotationUtils.findAnnotation(controller.get(), ApiSupport.class));
            HashSet<Tag> tags = new HashSet<Tag>();
            if (apiSupportAnnotation.isPresent() && !"".equalsIgnoreCase(author = (apiSupport = apiSupportAnnotation.get()).author())) {
                Integer order = apiSupport.order();
                if (tagSet.isEmpty()) {
                    Tag tag = new Tag(apiListingContext.getResourceGroup().getGroupName(), description, Lists.newArrayList(new ApiOrderExtension(order), new ApiAuthorExtension(author)));
                    tags.add(tag);
                }
            }
            apiListingContext.apiListingBuilder().description(description).tagNames(tagSet).tags(tags);
        }
    }

    private Function<Api, String> descriptionExtractor() {
        return new Function<Api, String>(){

            @Override
            public String apply(Api input) {
                return input.description();
            }
        };
    }

    private Function<Api, Set<String>> tags() {
        return new Function<Api, Set<String>>(){

            @Override
            public Set<String> apply(Api input) {
                return Sets.newTreeSet(FluentIterable.from(Lists.newArrayList(input.tags())).filter(Tags.emptyTags()).toSet());
            }
        };
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

